// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance Request.
 */
public class AgreementAcceptanceRequest extends BaseRequest implements IAgreementAcceptanceRequest {
	
    /**
     * The request for the AgreementAcceptance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementAcceptanceRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptance.class);
    }

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @return the AgreementAcceptance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementAcceptance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AgreementAcceptance sourceAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.PATCH, callback, sourceAgreementAcceptance);
    }

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @return the updated AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementAcceptance patch(final AgreementAcceptance sourceAgreementAcceptance) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AgreementAcceptance newAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.POST, callback, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementAcceptance post(final AgreementAcceptance newAgreementAcceptance) throws ClientException {
        return send(HttpMethod.POST, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AgreementAcceptance newAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback) {
        send(HttpMethod.PUT, callback, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementAcceptance put(final AgreementAcceptance newAgreementAcceptance) throws ClientException {
        return send(HttpMethod.PUT, newAgreementAcceptance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAgreementAcceptanceRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AgreementAcceptanceRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAgreementAcceptanceRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AgreementAcceptanceRequest)this;
     }

}

