// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ResourceOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Resource Operation Request.
 */
public interface IResourceOperationRequest extends IHttpRequest {

    /**
     * Gets the ResourceOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ResourceOperation> callback);

    /**
     * Gets the ResourceOperation from the service
     *
     * @return the ResourceOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ResourceOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ResourceOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ResourceOperation with a source
     *
     * @param sourceResourceOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ResourceOperation sourceResourceOperation, final ICallback<? super ResourceOperation> callback);

    /**
     * Patches this ResourceOperation with a source
     *
     * @param sourceResourceOperation the source object with updates
     * @return the updated ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ResourceOperation patch(final ResourceOperation sourceResourceOperation) throws ClientException;

    /**
     * Posts a ResourceOperation with a new object
     *
     * @param newResourceOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ResourceOperation newResourceOperation, final ICallback<? super ResourceOperation> callback);

    /**
     * Posts a ResourceOperation with a new object
     *
     * @param newResourceOperation the new object to create
     * @return the created ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ResourceOperation post(final ResourceOperation newResourceOperation) throws ClientException;

    /**
     * Posts a ResourceOperation with a new object
     *
     * @param newResourceOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ResourceOperation newResourceOperation, final ICallback<? super ResourceOperation> callback);

    /**
     * Posts a ResourceOperation with a new object
     *
     * @param newResourceOperation the object to create/update
     * @return the created ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ResourceOperation put(final ResourceOperation newResourceOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IResourceOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IResourceOperationRequest expand(final String value);

}

