// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookRange;
import com.microsoft.graph.models.extensions.WorkbookRangeView;
import com.microsoft.graph.requests.extensions.IWorkbookRangeFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookRangeSortRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Range Request Builder.
 */
public interface IWorkbookRangeRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookRangeRequest instance
     */
    IWorkbookRangeRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookRangeRequest instance
     */
    IWorkbookRangeRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    /**
     * Gets the request builder for WorkbookRangeFormat
     *
     * @return the IWorkbookRangeFormatRequestBuilder instance
     */
    IWorkbookRangeFormatRequestBuilder format();

    /**
     * Gets the request builder for WorkbookRangeSort
     *
     * @return the IWorkbookRangeSortRequestBuilder instance
     */
    IWorkbookRangeSortRequestBuilder sort();

    /**
     * Gets the request builder for WorkbookWorksheet
     *
     * @return the IWorkbookWorksheetRequestBuilder instance
     */
    IWorkbookWorksheetRequestBuilder worksheet();
    IWorkbookRangeClearRequestBuilder clear(final String applyTo);
    IWorkbookRangeDeleteRequestBuilder delete(final String shift);
    IWorkbookRangeInsertRequestBuilder insert(final String shift);
    IWorkbookRangeMergeRequestBuilder merge(final Boolean across);
    IWorkbookRangeUnmergeRequestBuilder unmerge();
    IWorkbookRangeBoundingRectRequestBuilder boundingRect(final String anotherRange);
    IWorkbookRangeCellRequestBuilder cell(final Integer row, final Integer column);
    IWorkbookRangeColumnRequestBuilder column(final Integer column);
    IWorkbookRangeColumnsAfterRequestBuilder columnsAfter();
    IWorkbookRangeColumnsAfterRequestBuilder columnsAfter(final Integer count);
    IWorkbookRangeColumnsBeforeRequestBuilder columnsBefore();
    IWorkbookRangeColumnsBeforeRequestBuilder columnsBefore(final Integer count);
    IWorkbookRangeEntireColumnRequestBuilder entireColumn();
    IWorkbookRangeEntireRowRequestBuilder entireRow();
    IWorkbookRangeIntersectionRequestBuilder intersection(final String anotherRange);
    IWorkbookRangeLastCellRequestBuilder lastCell();
    IWorkbookRangeLastColumnRequestBuilder lastColumn();
    IWorkbookRangeLastRowRequestBuilder lastRow();
    IWorkbookRangeOffsetRangeRequestBuilder offsetRange(final Integer rowOffset, final Integer columnOffset);
    IWorkbookRangeResizedRangeRequestBuilder resizedRange(final Integer deltaRows, final Integer deltaColumns);
    IWorkbookRangeRowRequestBuilder row(final Integer row);
    IWorkbookRangeRowsAboveRequestBuilder rowsAbove();
    IWorkbookRangeRowsAboveRequestBuilder rowsAbove(final Integer count);
    IWorkbookRangeRowsBelowRequestBuilder rowsBelow();
    IWorkbookRangeRowsBelowRequestBuilder rowsBelow(final Integer count);
    IWorkbookRangeUsedRangeRequestBuilder usedRange();
    IWorkbookRangeUsedRangeRequestBuilder usedRange(final Boolean valuesOnly);
    IWorkbookRangeVisibleViewRequestBuilder visibleView();

}