// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethod;
import com.microsoft.graph.requests.extensions.IDeviceRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Request.
 */
public class MicrosoftAuthenticatorAuthenticationMethodRequest extends BaseRequest implements IMicrosoftAuthenticatorAuthenticationMethodRequest {
	
    /**
     * The request for the MicrosoftAuthenticatorAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftAuthenticatorAuthenticationMethod.class);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftAuthenticatorAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        send(HttpMethod.PATCH, callback, sourceMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftAuthenticatorAuthenticationMethod patch(final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        send(HttpMethod.POST, callback, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftAuthenticatorAuthenticationMethod post(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        send(HttpMethod.PUT, callback, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Creates a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftAuthenticatorAuthenticationMethod put(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newMicrosoftAuthenticatorAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IMicrosoftAuthenticatorAuthenticationMethodRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (MicrosoftAuthenticatorAuthenticationMethodRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IMicrosoftAuthenticatorAuthenticationMethodRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (MicrosoftAuthenticatorAuthenticationMethodRequest)this;
     }

}

