// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintService;
import com.microsoft.graph.models.extensions.PrintServiceEndpoint;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IPrintServiceEndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Service Endpoint Collection Request Builder.
 */
public class PrintServiceEndpointCollectionRequestBuilder extends BaseRequestBuilder implements IPrintServiceEndpointCollectionRequestBuilder {

    /**
     * The request builder for this collection of PrintService
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintServiceEndpointCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IPrintServiceEndpointCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IPrintServiceEndpointCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new PrintServiceEndpointCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IPrintServiceEndpointRequestBuilder byId(final String id) {
        return new PrintServiceEndpointRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
