// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFilterApplyBottomItemsFilterRequest;
import com.microsoft.graph.requests.extensions.WorkbookFilterApplyBottomItemsFilterRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Filter Apply Bottom Items Filter Request Builder.
 */
public class WorkbookFilterApplyBottomItemsFilterRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFilterApplyBottomItemsFilterRequestBuilder {

    /**
     * The request builder for this WorkbookFilterApplyBottomItemsFilter
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param count the count
     */
    public WorkbookFilterApplyBottomItemsFilterRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final Integer count) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("count", count);
    }

    /**
     * Creates the IWorkbookFilterApplyBottomItemsFilterRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFilterApplyBottomItemsFilterRequest instance
     */
    public IWorkbookFilterApplyBottomItemsFilterRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookFilterApplyBottomItemsFilterRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFilterApplyBottomItemsFilterRequest instance
     */
    public IWorkbookFilterApplyBottomItemsFilterRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookFilterApplyBottomItemsFilterRequest request = new WorkbookFilterApplyBottomItemsFilterRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("count")) {
            request.body.count = getParameter("count");
        }

        return request;
    }
}
