/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.source;

import com.google.common.io.Closeables;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConfigurationSource
implements WatchedConfigurationSource,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperConfigurationSource.class);
    private final CuratorFramework client;
    private final String configRootPath;
    private final PathChildrenCache pathChildrenCache;
    private final Charset charset = Charset.forName("UTF-8");
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();

    public ZooKeeperConfigurationSource(CuratorFramework client, String configRootPath) {
        this.client = client;
        this.configRootPath = configRootPath;
        this.pathChildrenCache = new PathChildrenCache(client, configRootPath, true);
    }

    public void start() throws Exception {
        this.pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework aClient, PathChildrenCacheEvent event) throws Exception {
                PathChildrenCacheEvent.Type eventType = event.getType();
                ChildData data = event.getData();
                String path = null;
                if (data != null) {
                    path = data.getPath();
                    String key = ZooKeeperConfigurationSource.this.removeRootPath(path);
                    byte[] value = data.getData();
                    String stringValue = new String(value, ZooKeeperConfigurationSource.this.charset);
                    logger.debug("received update to pathName [{}], eventType [{}]", (Object)path, (Object)eventType);
                    logger.debug("key [{}], and value [{}]", (Object)key, (Object)stringValue);
                    HashMap<String, String> added = null;
                    HashMap<String, String> changed = null;
                    HashMap<String, String> deleted = null;
                    if (eventType == PathChildrenCacheEvent.Type.CHILD_ADDED) {
                        added = new HashMap<String, String>(1);
                        added.put(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                        changed = new HashMap<String, String>(1);
                        changed.put(key, stringValue);
                    } else if (eventType == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                        deleted = new HashMap<String, String>(1);
                        deleted.put(key, stringValue);
                    }
                    WatchedUpdateResult result = WatchedUpdateResult.createIncremental(added, changed, deleted);
                    ZooKeeperConfigurationSource.this.fireEvent(result);
                }
            }
        });
        this.pathChildrenCache.start(true);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        logger.debug("getCurrentData() retrieving current data.");
        List children = this.pathChildrenCache.getCurrentData();
        HashMap<String, Object> all = new HashMap<String, Object>(children.size());
        for (ChildData child : children) {
            String path = child.getPath();
            String key = this.removeRootPath(path);
            byte[] value = child.getData();
            all.put(key, new String(value, this.charset));
        }
        logger.debug("getCurrentData() retrieved [{}] config elements.", (Object)children.size());
        return all;
    }

    public void addUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(WatchedUpdateListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    protected void fireEvent(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                logger.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    private String removeRootPath(String nodePath) {
        return nodePath.replace(this.configRootPath + "/", "");
    }

    synchronized void setZkProperty(String key, String value) throws Exception {
        String path = this.configRootPath + "/" + key;
        byte[] data = value.getBytes(this.charset);
        try {
            this.client.create().creatingParentsIfNeeded().forPath(path, data);
        }
        catch (KeeperException.NodeExistsException exc) {
            this.client.setData().forPath(path, data);
        }
    }

    synchronized String getZkProperty(String key) throws Exception {
        String path = this.configRootPath + "/" + key;
        byte[] bytes = (byte[])this.client.getData().forPath(path);
        return new String(bytes, this.charset);
    }

    synchronized void deleteZkProperty(String key) throws Exception {
        String path = this.configRootPath + "/" + key;
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        Closeables.closeQuietly((Closeable)this.pathChildrenCache);
    }
}

