/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.AbstractColumnListMutation;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnPath;
import com.netflix.astyanax.thrift.ThriftSuperColumnMutationImpl;
import com.netflix.astyanax.thrift.ThriftUtils;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;

public class ThriftColumnFamilyMutationImpl<C>
extends AbstractColumnListMutation<C> {
    private final Serializer<C> columnSerializer;
    private final List<Mutation> mutationList;
    private Deletion lastDeletion;

    public ThriftColumnFamilyMutationImpl(Long timestamp, List<Mutation> mutationList, Serializer<C> columnSerializer) {
        super(timestamp.longValue());
        this.mutationList = mutationList;
        this.columnSerializer = columnSerializer;
    }

    public <SC> ColumnListMutation<SC> withSuperColumn(ColumnPath<SC> superColumnPath) {
        return new ThriftSuperColumnMutationImpl<SC>(this.timestamp, this.mutationList, superColumnPath);
    }

    public <V> ColumnListMutation<C> putColumn(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        Column column = new Column();
        column.setName(this.columnSerializer.toByteBuffer(columnName));
        column.setValue(valueSerializer.toByteBuffer(value));
        column.setTimestamp(this.timestamp);
        if (ttl != null) {
            if (ttl > 0) {
                column.setTtl(ttl.intValue());
            }
        } else if (this.defaultTtl != null) {
            column.setTtl(this.defaultTtl.intValue());
        }
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setColumn(column));
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName, Integer ttl) {
        Column column = new Column();
        column.setName(this.columnSerializer.toByteBuffer(columnName));
        column.setValue(ThriftUtils.EMPTY_BYTE_BUFFER);
        column.setTimestamp(this.timestamp);
        if (ttl != null) {
            if (ttl > 0) {
                column.setTtl(ttl.intValue());
            }
        } else if (this.defaultTtl != null) {
            column.setTtl(this.defaultTtl.intValue());
        }
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setColumn(column));
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> delete() {
        Deletion d = new Deletion().setTimestamp(this.timestamp);
        this.mutationList.add(new Mutation().setDeletion(d));
        ++this.timestamp;
        return this;
    }

    public ColumnListMutation<C> incrementCounterColumn(C columnName, long amount) {
        CounterColumn column = new CounterColumn();
        column.setName(this.columnSerializer.toByteBuffer(columnName));
        column.setValue(amount);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setCounter_column(column));
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> deleteColumn(C columnName) {
        if (null == this.lastDeletion || this.lastDeletion.getTimestamp() != this.timestamp) {
            this.lastDeletion = new Deletion().setPredicate(new SlicePredicate()).setTimestamp(this.timestamp);
            this.mutationList.add(new Mutation().setDeletion(this.lastDeletion));
        }
        ByteBuffer bb = this.columnSerializer.toByteBuffer(columnName);
        this.lastDeletion.getPredicate().addToColumn_names(bb);
        return this;
    }
}

