/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.thrift.ThriftTypes;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftUtils.class);
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    public static final int MUTATION_OVERHEAD = 20;

    public static SliceRange createAllInclusiveSliceRange() {
        return new SliceRange(EMPTY_BYTE_BUFFER, EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE);
    }

    public static <C> SliceRange createSliceRange(Serializer<C> serializer, C startColumn, C endColumn, boolean reversed, int limit) {
        return new SliceRange(startColumn == null ? EMPTY_BYTE_BUFFER : serializer.toByteBuffer(startColumn), endColumn == null ? EMPTY_BYTE_BUFFER : serializer.toByteBuffer(endColumn), reversed, limit);
    }

    public static <T extends TBase> Properties getPropertiesFromThrift(T entity) throws Exception {
        Properties props = new Properties();
        ThriftUtils.setPropertiesFromThrift("", props, entity);
        return props;
    }

    public static void setPropertiesFromThrift(String prefix, Properties properties, TBase entity) throws Exception {
        Field field = entity.getClass().getDeclaredField("metaDataMap");
        Map fields = (Map)field.get(entity);
        block7: for (Map.Entry f : fields.entrySet()) {
            ThriftTypes type = ThriftTypes.values()[((FieldMetaData)f.getValue()).valueMetaData.type];
            Object value = entity.getFieldValue((TFieldIdEnum)f.getKey());
            if (value == null) continue;
            switch (type) {
                case VOID: {
                    break;
                }
                case BOOL: 
                case BYTE: 
                case DOUBLE: 
                case I16: 
                case I32: 
                case I64: 
                case STRING: 
                case ENUM: {
                    if (value instanceof byte[]) {
                        properties.put(prefix + ((TFieldIdEnum)f.getKey()).getFieldName(), Base64.encodeBase64String((byte[])((byte[])value)));
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        properties.put(prefix + ((TFieldIdEnum)f.getKey()).getFieldName(), ThriftUtils.base64Encode((ByteBuffer)value));
                        break;
                    }
                    properties.put(prefix + ((TFieldIdEnum)f.getKey()).getFieldName(), value.toString());
                    break;
                }
                case MAP: {
                    String newPrefix = prefix + ((TFieldIdEnum)f.getKey()).getFieldName() + ".";
                    MapMetaData meta = (MapMetaData)((FieldMetaData)f.getValue()).valueMetaData;
                    if (!meta.keyMetaData.isStruct() && !meta.keyMetaData.isContainer()) {
                        Map map = (Map)value;
                        for (Map.Entry entry : map.entrySet()) {
                            properties.put(newPrefix + entry.getKey(), entry.getValue().toString());
                        }
                        continue block7;
                    }
                    LOG.error(String.format("Unable to serializer field '%s' key type '%s' not supported", ((TFieldIdEnum)f.getKey()).getFieldName(), meta.keyMetaData.getTypedefName()));
                    break;
                }
                case LIST: {
                    String newPrefix = prefix + ((TFieldIdEnum)f.getKey()).getFieldName() + ".";
                    List list = (List)value;
                    ListMetaData listMeta = (ListMetaData)((FieldMetaData)f.getValue()).valueMetaData;
                    for (Object e : list) {
                        String id;
                        if (e instanceof CfDef) {
                            id = ((CfDef)e).name;
                        } else if (e instanceof ColumnDef) {
                            ByteBuffer name = ((ColumnDef)e).name;
                            id = ThriftUtils.base64Encode(name);
                        } else {
                            LOG.error("Don't know how to convert to properties " + listMeta.elemMetaData.getTypedefName());
                            continue;
                        }
                        if (listMeta.elemMetaData.isStruct()) {
                            ThriftUtils.setPropertiesFromThrift(newPrefix + id + ".", properties, (TBase)e);
                            continue;
                        }
                        properties.put(newPrefix + id, e);
                    }
                    continue block7;
                }
                case STRUCT: {
                    ThriftUtils.setPropertiesFromThrift(prefix + ((TFieldIdEnum)f.getKey()).getFieldName() + ".", properties, (TBase)value);
                    break;
                }
                default: {
                    LOG.error("Unhandled value : " + ((TFieldIdEnum)f.getKey()).getFieldName() + " " + (Object)((Object)type));
                }
            }
        }
    }

    private static String base64Encode(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        byte[] nbb = new byte[bb.remaining()];
        bb.duplicate().get(nbb, 0, bb.remaining());
        return Base64.encodeBase64String((byte[])nbb);
    }

    public static <T> T getThriftObjectFromProperties(Class<T> clazz, Properties props) throws Exception {
        TBase entity = (TBase)clazz.newInstance();
        return (T)ThriftUtils.populateObjectFromProperties(entity, props);
    }

    public static Object populateObjectFromProperties(Object entity, Properties props) throws Exception {
        return ThriftUtils.populateObject(entity, ThriftUtils.propertiesToMap(props));
    }

    private static Object populateObject(Object obj, Map<String, Object> map) throws Exception {
        TBase entity = (TBase)obj;
        Field field = entity.getClass().getDeclaredField("metaDataMap");
        Map fields = (Map)field.get(entity);
        block10: for (Map.Entry f : fields.entrySet()) {
            Object value = map.get(((TFieldIdEnum)f.getKey()).getFieldName());
            if (value == null) continue;
            ThriftTypes type = ThriftTypes.values()[((FieldMetaData)f.getValue()).valueMetaData.type];
            switch (type) {
                case VOID: {
                    break;
                }
                case BOOL: 
                case BYTE: 
                case DOUBLE: 
                case I16: 
                case I32: 
                case I64: 
                case STRING: {
                    try {
                        entity.setFieldValue((TFieldIdEnum)f.getKey(), ThriftUtils.valueForBasicType(value, ((FieldMetaData)f.getValue()).valueMetaData.type));
                        break;
                    }
                    catch (ClassCastException e) {
                        if (e.getMessage().contains(ByteBuffer.class.getCanonicalName())) {
                            entity.setFieldValue((TFieldIdEnum)f.getKey(), (Object)ByteBuffer.wrap(Base64.decodeBase64((String)((String)value))));
                            break;
                        }
                        throw e;
                    }
                }
                case ENUM: {
                    EnumMetaData meta = (EnumMetaData)((FieldMetaData)f.getValue()).valueMetaData;
                    Class e = meta.enumClass;
                    if (!(e instanceof Enum)) continue block10;
                    entity.setFieldValue((TFieldIdEnum)f.getKey(), Enum.valueOf(e, (String)value));
                    break;
                }
                case MAP: {
                    EnumMetaData meta = (MapMetaData)((FieldMetaData)f.getValue()).valueMetaData;
                    if (!meta.keyMetaData.isStruct() && !meta.keyMetaData.isContainer()) {
                        Map childMap = (Map)value;
                        HashMap childEntityMap = Maps.newHashMap();
                        entity.setFieldValue((TFieldIdEnum)f.getKey(), (Object)childEntityMap);
                        if (meta.keyMetaData.isStruct() || meta.keyMetaData.isContainer()) continue block10;
                        for (Map.Entry entry : childMap.entrySet()) {
                            Object childKey = ThriftUtils.valueForBasicType(entry.getKey(), meta.keyMetaData.type);
                            Object childValue = ThriftUtils.valueForBasicType(entry.getValue(), meta.valueMetaData.type);
                            childEntityMap.put(childKey, childValue);
                        }
                        continue block10;
                    }
                    LOG.error(String.format("Unable to serializer field '%s' key type '%s' not supported", ((TFieldIdEnum)f.getKey()).getFieldName(), meta.keyMetaData.getTypedefName()));
                    break;
                }
                case LIST: {
                    Map childMap = (Map)value;
                    ListMetaData listMeta = (ListMetaData)((FieldMetaData)f.getValue()).valueMetaData;
                    ArrayList childList = Lists.newArrayList();
                    entity.setFieldValue((TFieldIdEnum)f.getKey(), (Object)childList);
                    if (!(listMeta.elemMetaData instanceof StructMetaData)) continue block10;
                    StructMetaData structMeta = (StructMetaData)listMeta.elemMetaData;
                    for (Map.Entry childElement : childMap.entrySet()) {
                        TBase childEntity = (TBase)structMeta.structClass.newInstance();
                        ThriftUtils.populateObject(childEntity, (Map)childElement.getValue());
                        childList.add(childEntity);
                    }
                    continue block10;
                }
                case STRUCT: {
                    break;
                }
                default: {
                    LOG.error("Unhandled value : " + ((TFieldIdEnum)f.getKey()).getFieldName() + " " + (Object)((Object)type));
                }
            }
        }
        return entity;
    }

    public static Object valueForBasicType(Object value, byte type) {
        switch (ThriftTypes.values()[type]) {
            case BYTE: {
                return Byte.parseByte((String)value);
            }
            case BOOL: {
                return Boolean.parseBoolean((String)value);
            }
            case DOUBLE: {
                return Double.parseDouble((String)value);
            }
            case I16: {
                return Short.parseShort((String)value);
            }
            case I32: {
                return Integer.parseInt((String)value);
            }
            case I64: {
                return Long.parseLong((String)value);
            }
            case STRING: {
                return value;
            }
        }
        return null;
    }

    public static Map<String, Object> propertiesToMap(Properties props) {
        TreeMap root = Maps.newTreeMap();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String[] parts = StringUtils.split((String)((String)prop.getKey()), (String)".");
            Map node = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!node.containsKey(parts[i])) {
                    node.put(parts[i], new LinkedHashMap());
                }
                node = (Map)node.get(parts[i]);
            }
            node.put(parts[parts.length - 1], (String)prop.getValue());
        }
        return root;
    }
}

