/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnImpl;
import com.netflix.astyanax.model.ColumnList;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.Column;

public class ThriftColumnImpl<C>
extends AbstractColumnImpl<C> {
    private final Column column;

    public ThriftColumnImpl(C name, Column column) {
        super(name);
        this.column = column;
    }

    public <V> V getValue(Serializer<V> valSer) {
        return (V)valSer.fromBytes(this.column.getValue());
    }

    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        throw new UnsupportedOperationException("SimpleColumn '" + this.getName() + "' has no children");
    }

    public boolean isParentColumn() {
        return false;
    }

    public long getTimestamp() {
        return this.column.getTimestamp();
    }

    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.column.getName());
    }

    public int getTtl() {
        return this.column.isSetTtl() ? this.column.getTtl() : 0;
    }

    public boolean hasValue() {
        return this.column.value != null && this.column.value.remaining() != 0;
    }
}

