/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.provider;

import com.netflix.discovery.provider.ISerializer;
import com.netflix.discovery.provider.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class DiscoveryJerseyProvider
implements MessageBodyWriter,
MessageBodyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryJerseyProvider.class);
    private static ConcurrentHashMap<Class, ISerializer> serializers = new ConcurrentHashMap();

    public boolean isReadable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.checkForAnnotation(serializableClass);
    }

    public Object readFrom(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, InputStream inputStream) throws IOException, WebApplicationException {
        try {
            return this.getSerializer(serializableClass).read(inputStream, serializableClass, mediaType);
        }
        catch (Throwable th) {
            new IOException("Cannot read the object for :" + serializableClass, th);
            return null;
        }
    }

    public long getSize(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.checkForAnnotation(serializableClass);
    }

    public void writeTo(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, OutputStream outputStream) throws IOException, WebApplicationException {
        try {
            ISerializer serializer = this.getSerializer(serializableClass);
            serializer.write(serializableObject, outputStream, mediaType);
        }
        catch (Throwable th) {
            throw new IOException("Cannot write the object for :" + serializableClass, th);
        }
    }

    private boolean checkForAnnotation(Class serializableClass) {
        try {
            Serializer annotation = serializableClass.getAnnotation(Serializer.class);
            if (annotation != null) {
                return true;
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Exception in checking for annotations", th);
        }
        return false;
    }

    private ISerializer getSerializer(Class serializableClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Serializer payloadConverter;
        String serializer;
        ISerializer converter = null;
        Serializer annotation = serializableClass.getAnnotation(Serializer.class);
        if (annotation != null && (serializer = (payloadConverter = annotation).value()) != null && (converter = serializers.get(serializableClass)) == null) {
            converter = (ISerializer)Class.forName(serializer).newInstance();
            serializers.put(serializableClass, converter);
        }
        return converter;
    }
}

