/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.dynaview.DynaviewEngine;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.FacesNavigationURLCanonicalizer;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyNavigationHandler
extends ConfigurableNavigationHandler {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final ConfigurableNavigationHandler parent;
    private final PrettyRedirector pr = PrettyRedirector.getInstance();
    private final DynaviewEngine dynaview = new DynaviewEngine();

    public PrettyNavigationHandler(ConfigurableNavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        log.debug("Navigation requested: fromAction [" + fromAction + "], outcome [" + outcome + "]");
        if (!this.pr.redirect(context, outcome)) {
            log.debug("Not a PrettyFaces navigation string - passing control to default nav-handler");
            PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
            prettyContext.setInNavigation(true);
            String originalViewId = context.getViewRoot().getViewId();
            this.parent.handleNavigation(context, fromAction, outcome);
            String newViewId = context.getViewRoot().getViewId();
            if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
                prettyContext.setInNavigation(false);
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        PrettyConfig config = prettyContext.getConfig();
        if (outcome != null && "pretty:".equals(outcome)) {
            String viewId = context.getViewRoot().getViewId();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, viewId);
            return navigationCase;
        }
        if (outcome != null && outcome.startsWith("pretty:") && config.isMappingId(outcome)) {
            UrlMapping mapping = config.getMappingById(outcome);
            String viewId = mapping.getViewId();
            if (mapping.isDynaView()) {
                viewId = this.dynaview.calculateDynaviewId(context, mapping);
            }
            viewId = FacesNavigationURLCanonicalizer.normalizeRequestURI(context, viewId);
            URL url = new URL(viewId);
            url.getMetadata().setLeadingSlash(true);
            QueryString qs = QueryString.build("");
            if (viewId.contains("?")) {
                qs.addParameters(viewId);
            }
            qs.addParameters("?com.ocpsoft.mappingId=" + mapping.getId());
            viewId = url.toString() + qs.toQueryString();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, viewId);
            return navigationCase;
        }
        NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, outcome);
        return navigationCase;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.parent.getNavigationCases();
    }

    public void performNavigation(String outcome) {
        this.parent.performNavigation(outcome);
    }
}

