/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.pretty.faces.util.EmptyEntityResolver;
import com.ocpsoft.shade.org.apache.commons.digester.Digester;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigBeanNameResolver
implements ELBeanNameResolver {
    private static final Log log = LogFactory.getLog(FacesConfigBeanNameResolver.class);
    private static final String WEB_INF_FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";
    private static final String META_INF_FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private Map<String, String> beanNameMap = new HashMap<String, String>();

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        ArrayList<FacesConfigEntry> facesConfigEntries = new ArrayList<FacesConfigEntry>();
        Set<URL> facesConfigs = this.getFacesConfigFiles(servletContext, classLoader);
        for (URL url : facesConfigs) {
            this.processFacesConfig(url, facesConfigEntries);
        }
        for (FacesConfigEntry entry : facesConfigEntries) {
            this.beanNameMap.put(entry.getBeanClass(), entry.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Found " + this.beanNameMap.size() + " bean names in faces configuration.");
        }
        return true;
    }

    private Set<URL> getFacesConfigFiles(ServletContext servletContext, ClassLoader classLoader) {
        HashSet<URL> result = new HashSet<URL>();
        try {
            URL defaultFacesConfig = servletContext.getResource(WEB_INF_FACES_CONFIG_XML);
            if (defaultFacesConfig != null) {
                result.add(defaultFacesConfig);
            }
            result.addAll(this.getConfigFilesFromInitParameter(servletContext));
            try {
                Enumeration<URL> resources = classLoader.getResources(META_INF_FACES_CONFIG_XML);
                while (resources.hasMoreElements()) {
                    result.add(resources.nextElement());
                }
            }
            catch (IOException e) {
                log.error("Failed to load faces-config.xml files from META-INF directories", e);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private Collection<URL> getConfigFilesFromInitParameter(ServletContext servletContext) {
        String initParam = servletContext.getInitParameter("javax.faces.CONFIG_FILES");
        if (initParam == null || initParam.trim().length() == 0) {
            return Collections.emptySet();
        }
        String[] files = initParam.split(",");
        HashSet<URL> result = new HashSet<URL>();
        for (String file : files) {
            if (file.trim().length() == 0) continue;
            try {
                URL url = servletContext.getResource(file.trim());
                if (url == null) continue;
                result.add(url);
            }
            catch (MalformedURLException e) {
                log.debug("Invalid entry in javax.faces.CONFIG_FILES init parameter: " + file);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFacesConfig(URL url, List<FacesConfigEntry> facesConfigEntries) {
        if (log.isTraceEnabled()) {
            log.trace("Loading bean names from: " + url.toString());
        }
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setEntityResolver(new EmptyEntityResolver());
        digester.setValidating(false);
        digester.push(facesConfigEntries);
        digester.addObjectCreate("faces-config/managed-bean", FacesConfigEntry.class);
        digester.addCallMethod("faces-config/managed-bean/managed-bean-name", "setName", 0);
        digester.addCallMethod("faces-config/managed-bean/managed-bean-class", "setBeanClass", 0);
        digester.addSetNext("faces-config/managed-bean", "add");
        InputStream stream = null;
        try {
            stream = url.openStream();
            digester.parse(stream);
        }
        catch (IOException e) {
            log.warn("Failed to parse: " + url.toString() + ": " + e.getMessage());
        }
        catch (SAXException e) {
            log.warn("Failed to parse: " + url.toString() + ": " + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        String name = this.beanNameMap.get(clazz.getName());
        if (name != null) {
            return name;
        }
        return null;
    }

    public static class FacesConfigEntry {
        private String name;
        private String beanClass;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBeanClass() {
            return this.beanClass;
        }

        public void setBeanClass(String beanClass) {
            this.beanClass = beanClass;
        }
    }
}

