/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.AbstractPlatform;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.DockerRemoteTerminal;
import com.oracle.bedrock.runtime.docker.commands.AbstractDockerCommand;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.remote.RemoteTerminalBuilder;
import com.oracle.bedrock.runtime.remote.SimpleRemoteApplicationLauncher;
import com.oracle.bedrock.runtime.remote.java.RemoteJavaApplicationLauncher;
import com.oracle.bedrock.util.Version;
import java.net.InetAddress;

public class DockerPlatform
extends AbstractPlatform {
    private final Platform clientPlatform;
    private final Docker docker;

    public DockerPlatform(Platform clientPlatform, Docker docker, Option ... options) {
        this(clientPlatform.getName(), clientPlatform, docker, options);
    }

    public DockerPlatform(String name, Platform clientPlatform, Docker docker, Option ... options) {
        super(name, options);
        this.clientPlatform = clientPlatform;
        this.docker = docker;
        this.getOptions().add((Option)docker);
    }

    public Platform getClientPlatform() {
        return this.clientPlatform;
    }

    public Docker getDocker() {
        return this.docker;
    }

    public OperatingSystem getOperatingSystem() {
        return OperatingSystem.custom((String)"Generic", (String)"", (OperatingSystem.Type)OperatingSystem.Type.LINUX, (Version)Version.of((String[])new String[]{"1.0"}));
    }

    public InetAddress getAddress() {
        return this.docker.getDaemonInetAddress(this.clientPlatform);
    }

    public <A extends Application> A launch(MetaClass<A> metaClass, Option ... options) {
        OptionsByType launchOptions = OptionsByType.of((OptionsByType)this.getOptions());
        launchOptions.addAll(options);
        launchOptions.addIfAbsent((Option)this.docker);
        if (metaClass instanceof AbstractDockerCommand) {
            return (A)this.clientPlatform.launch(metaClass, launchOptions.asArray());
        }
        DockerRemoteTerminal terminal = new DockerRemoteTerminal(this.clientPlatform);
        RemoteTerminalBuilder builder = platform -> terminal;
        launchOptions.add((Option)builder);
        launchOptions.add((Option)terminal);
        return (A)super.launch(metaClass, launchOptions.asArray());
    }

    protected <A extends Application, B extends ApplicationLauncher<A>> B getApplicationLauncher(MetaClass<A> metaClass, OptionsByType optionsByType) throws UnsupportedOperationException {
        Class applicationClass = metaClass.getImplementationClass((Platform)this, optionsByType);
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new RemoteJavaApplicationLauncher();
        }
        return (B)new SimpleRemoteApplicationLauncher();
    }

    public static DockerPlatform localClient() {
        return DockerPlatform.clientAt((Platform)LocalPlatform.get(), Docker.auto());
    }

    public static DockerPlatform localClient(Docker environment) {
        return DockerPlatform.clientAt((Platform)LocalPlatform.get(), environment);
    }

    public static DockerPlatform clientAt(Platform platform, Docker environment) {
        return new DockerPlatform(platform, environment, new Option[0]);
    }
}

