/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.DockerImage;
import com.oracle.bedrock.runtime.docker.commands.AbstractDockerCommand;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Build
extends AbstractDockerCommand<Build> {
    public static final Timeout DEFAULT_TIMEOUT = Timeout.after((long)5L, (TimeUnit)TimeUnit.MINUTES);
    private Object contextLocation;

    private Build() {
        super("build");
        this.contextLocation = ".";
    }

    private Build(Arguments arguments, Object contextLocation) {
        super(arguments);
        this.contextLocation = contextLocation;
    }

    @Override
    public Build withCommandArguments(Argument ... args) {
        return new Build(this.getCommandArguments().with(args), this.contextLocation);
    }

    @Override
    public Build withoutCommandArguments(Argument ... args) {
        return new Build(this.getCommandArguments().without(args), this.contextLocation);
    }

    public Build withTags(Object ... tags) {
        Argument argument = Argument.of((String)"--tag", (char)'=', (Object)new Argument.Multiple(tags), (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build buildContextAt(File location) {
        return new Build(this.getCommandArguments(), location);
    }

    public Build buildContextAt(URL location) {
        return new Build(this.getCommandArguments(), location);
    }

    public Build buildArgs(Object ... args) {
        Argument argument = Argument.of((String)"--build-arg", (char)'=', (Object)new Argument.Multiple(args), (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build cpuShares() {
        return this.cpuShares(true);
    }

    public Build cpuShares(boolean enabled) {
        if (enabled) {
            return new Build(this.getCommandArguments().with(Argument.of((Object)"--cpu-shares", (Option[])new Option[0])), this.contextLocation);
        }
        return new Build(this.getCommandArguments().without(Argument.of((Object)"--cpu-shares", (Option[])new Option[0])), this.contextLocation);
    }

    public Build cgroupParent(String parent) {
        Argument argument = Argument.of((String)"--cgroup-parent", (char)'=', (Object)parent, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build cpuPeriod(int value) {
        Argument argument = Argument.of((String)"--cpu-period", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build cpuQuota(int value) {
        Argument argument = Argument.of((String)"--cpu-quota", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build cpuSetCPUs(String value) {
        Argument argument = Argument.of((String)"--cpuset-cpus", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build cpuSetMems(String value) {
        Argument argument = Argument.of((String)"--cpuset-mems", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build disableContentTrust() {
        Argument argument = Argument.of((String)"--disable-content-trust", (char)'=', (Object)true, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build enableContentTrust() {
        Argument argument = Argument.of((String)"--disable-content-trust", (char)'=', (Object)false, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build dockerFileName(String name) {
        Argument argument = Argument.of((String)"--file", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build forceRM() {
        return this.forceRM(true);
    }

    public Build forceRM(boolean force) {
        if (force) {
            return new Build(this.getCommandArguments().with(Argument.of((Object)"--force-rm", (Option[])new Option[0])), this.contextLocation);
        }
        return new Build(this.getCommandArguments().without(Argument.of((Object)"--force-rm", (Option[])new Option[0])), this.contextLocation);
    }

    public Build isolation(String value) {
        Argument argument = Argument.of((String)"--isolation", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build labels(Object ... values) {
        Argument argument = Argument.of((String)"--label", (char)'=', (Object)new Argument.Multiple(values), (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build memory(String limit) {
        Argument argument = Argument.of((String)"--memory", (char)'=', (Object)limit, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build memorySwap(String swap) {
        Argument argument = Argument.of((String)"--memory-swap", (char)'=', (Object)swap, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build noCache() {
        return this.noCache(true);
    }

    public Build noCache(boolean noCache) {
        if (noCache) {
            return new Build(this.getCommandArguments().with(Argument.of((Object)"--no-cache", (Option[])new Option[0])), this.contextLocation);
        }
        return new Build(this.getCommandArguments().without(Argument.of((Object)"--no-cache", (Option[])new Option[0])), this.contextLocation);
    }

    public Build alwaysPull() {
        return new Build(this.getCommandArguments().with(Argument.of((Object)"--pull", (Option[])new Option[0])), this.contextLocation);
    }

    public Build quiet() {
        return this.quiet(true);
    }

    public Build quiet(boolean quiet) {
        if (quiet) {
            return new Build(this.getCommandArguments().with(Argument.of((Object)"--quiet", (Option[])new Option[0])), this.contextLocation);
        }
        return new Build(this.getCommandArguments().without(Argument.of((Object)"--quiet", (Option[])new Option[0])), this.contextLocation);
    }

    public Build removeIntermidiateContainers() {
        return this.removeIntermidiateContainers(true);
    }

    public Build removeIntermidiateContainers(boolean rm) {
        Argument argument = Argument.of((String)"--rm", (char)'=', (Object)rm, (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build shmSize(Object ... values) {
        Argument argument = Argument.of((String)"--shm-size", (char)'=', (Object)new Argument.Multiple(values), (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    public Build ulimit(Object ... options) {
        Argument argument = Argument.of((String)"--ulimit", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0]);
        return new Build(this.getCommandArguments().replace(argument), this.contextLocation);
    }

    @Override
    public void onLaunch(Platform platform, OptionsByType optionsByType) {
        Timeout timeout = this.getTimeout();
        if (timeout == null) {
            timeout = DEFAULT_TIMEOUT;
        }
        optionsByType.addIfAbsent((Option)timeout);
        super.onLaunch(platform, optionsByType);
        optionsByType.add((Option)Argument.of((Object)this.contextLocation, (Option[])new Option[0]));
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
        Arguments arguments = (Arguments)optionsByType.get(Arguments.class, new Object[0]);
        String tagPrefix = "--tag=";
        int prefixLen = tagPrefix.length();
        List<String> tags = arguments.stream().map(arg -> String.valueOf(arg.getValue())).filter(tagArg -> tagArg.startsWith(tagPrefix)).map(tagArg -> tagArg.substring(prefixLen)).collect(Collectors.toList());
        DockerImage image = new DockerImage(tags, optionsByType);
        application.add((Object)image);
    }

    public static Build fromDockerFile() {
        return new Build().dockerFileName("Dockerfile").withTags(UUID.randomUUID().toString());
    }

    public static Build fromDockerFile(String dockerFileName) {
        return Build.fromDockerFile().dockerFileName(dockerFileName);
    }
}

