/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.docker.commands.CommandWithArgumentList;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Remove<R extends Remove>
extends CommandWithArgumentList<R> {
    private Remove(Arguments arguments, List<?> names) {
        super(arguments, names);
    }

    private Remove(String command, List<?> names) {
        super(command, names);
    }

    public static RemoveContainer containers(Object ... names) {
        return Remove.containers(Arrays.asList(names));
    }

    public static RemoveContainer containers(List<?> names) {
        return new RemoveContainer(names);
    }

    public static Remove link(String first, String second) {
        List<String> names = Collections.singletonList(first + '/' + second);
        return (Remove)new RemoveLink(names).withCommandArguments(new Argument[]{Argument.of((Object)"--link", (Option[])new Option[0])});
    }

    public static RemoveImage images(Object ... tags) {
        return Remove.images(Arrays.asList(tags));
    }

    public static RemoveImage images(List<?> tags) {
        return new RemoveImage(tags);
    }

    public static class RemoveLink
    extends Remove<RemoveLink> {
        private RemoveLink(List<?> names) {
            super("rm", names);
        }

        private RemoveLink(Arguments arguments, List<?> names) {
            super(arguments, names);
        }

        @Override
        protected RemoveLink withCommandArguments(List<Argument> containers, Argument ... args) {
            return new RemoveLink(this.getCommandArguments().with(args), containers);
        }

        @Override
        protected RemoveLink withoutCommandArguments(List<Argument> names, Argument ... args) {
            return new RemoveLink(this.getCommandArguments().without(args), names);
        }
    }

    public static class RemoveImage
    extends Remove<RemoveImage> {
        private RemoveImage(List<?> images) {
            super("rmi", images);
        }

        private RemoveImage(Arguments arguments, List<?> names) {
            super(arguments, names);
        }

        public RemoveImage force() {
            return this.force(true);
        }

        public RemoveImage force(boolean force) {
            if (force) {
                return (RemoveImage)this.withCommandArguments(new Argument[]{Argument.of((Object)"--force", (Option[])new Option[0])});
            }
            return (RemoveImage)this.withoutCommandArguments(new Argument[]{Argument.of((Object)"--force", (Option[])new Option[0])});
        }

        public RemoveImage noPrune() {
            return this.noPrune(true);
        }

        public RemoveImage noPrune(boolean noPrune) {
            if (noPrune) {
                return (RemoveImage)this.withCommandArguments(new Argument[]{Argument.of((Object)"--no-prune", (Option[])new Option[0])});
            }
            return (RemoveImage)this.withoutCommandArguments(new Argument[]{Argument.of((Object)"--no-prune", (Option[])new Option[0])});
        }

        @Override
        protected RemoveImage withCommandArguments(List<Argument> images, Argument ... args) {
            return new RemoveImage(this.getCommandArguments().with(args), images);
        }

        @Override
        protected RemoveImage withoutCommandArguments(List<Argument> names, Argument ... args) {
            return new RemoveImage(this.getCommandArguments().without(args), names);
        }
    }

    public static class RemoveContainer
    extends Remove<RemoveContainer> {
        private RemoveContainer(List<?> containers) {
            super("rm", containers);
        }

        private RemoveContainer(Arguments arguments, List<?> containers) {
            super(arguments, containers);
        }

        public RemoveContainer force() {
            return this.force(true);
        }

        public RemoveContainer force(boolean force) {
            if (force) {
                return (RemoveContainer)this.withCommandArguments(new Argument[]{Argument.of((Object)"--force", (Option[])new Option[0])});
            }
            return (RemoveContainer)this.withoutCommandArguments(new Argument[]{Argument.of((Object)"--force", (Option[])new Option[0])});
        }

        public RemoveContainer andVolumes() {
            return this.andVolumes(true);
        }

        public RemoveContainer andVolumes(boolean remove) {
            if (remove) {
                return (RemoveContainer)this.withCommandArguments(new Argument[]{Argument.of((Object)"--volumes", (Option[])new Option[0])});
            }
            return (RemoveContainer)this.withoutCommandArguments(new Argument[]{Argument.of((Object)"--volumes", (Option[])new Option[0])});
        }

        @Override
        protected RemoveContainer withCommandArguments(List<Argument> containers, Argument ... args) {
            return new RemoveContainer(this.getCommandArguments().with(args), containers);
        }

        @Override
        protected RemoveContainer withoutCommandArguments(List<Argument> names, Argument ... args) {
            return new RemoveContainer(this.getCommandArguments().without(args), names);
        }
    }
}

