/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.DockerContainer;
import com.oracle.bedrock.runtime.docker.DockerImage;
import com.oracle.bedrock.runtime.docker.commands.AbstractDockerCommand;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.EnvironmentVariable;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class Run
extends AbstractDockerCommand<Run> {
    private final Argument imageArgument;
    private List<EnvironmentVariable> environmentVariables;

    private Run(String imageName, Object containerName) {
        this(Arguments.of((Argument[])new Argument[]{Argument.of((Object)"run", (Option[])new Option[0]), Argument.of((String)"--name", (char)'=', (Object)containerName, (Option[])new Option[0])}), imageName, new ArrayList<EnvironmentVariable>());
    }

    private Run(Arguments commandOptions, Object image, List<EnvironmentVariable> environmentVariables) {
        super(commandOptions);
        this.imageArgument = Argument.of((Object)image, (Option[])new Option[0]);
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Run withCommandArguments(Argument ... args) {
        return new Run(this.getCommandArguments().with(args), this.imageArgument, this.environmentVariables);
    }

    @Override
    public Run withoutCommandArguments(Argument ... args) {
        return new Run(this.getCommandArguments().without(args), this.imageArgument, this.environmentVariables);
    }

    public Run detached() {
        Arguments args = this.getCommandArguments().with(Argument.of((Object)"--detach", (Option[])new Option[0])).without(Argument.of((Object)"--interactive", (Option[])new Option[0]));
        return new Run(args, this.imageArgument, this.environmentVariables);
    }

    public Run interactive() {
        Arguments args = this.getCommandArguments().with(Argument.of((Object)"--interactive", (Option[])new Option[0])).without(Argument.of((Object)"--detach", (Option[])new Option[0]));
        return new Run(args, this.imageArgument, this.environmentVariables);
    }

    public Run tty() {
        return this.withCommandArguments(Argument.of((Object)"--tty", (Option[])new Option[0]));
    }

    public Run env(String name) {
        ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(this.environmentVariables);
        variables.add(EnvironmentVariable.of((String)name));
        return new Run(this.getCommandArguments(), this.imageArgument, variables);
    }

    public Run env(String name, Object value) {
        ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(this.environmentVariables);
        variables.add(EnvironmentVariable.of((String)name, (Object)value));
        return new Run(this.getCommandArguments(), this.imageArgument, variables);
    }

    public Run env(Properties variables) {
        if (variables == null || variables.isEmpty()) {
            return this;
        }
        ArrayList<EnvironmentVariable> copy = new ArrayList<EnvironmentVariable>(this.environmentVariables);
        variables.entrySet().stream().map(entry -> EnvironmentVariable.of((String)entry.getKey().toString(), entry.getValue())).forEach(copy::add);
        return new Run(this.getCommandArguments(), this.imageArgument, copy);
    }

    public Run expose(Object ... ports) {
        Argument arg = Argument.of((String)"--expose", (char)'=', (Object)new Argument.Multiple(ports), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(arg), this.imageArgument, this.environmentVariables);
    }

    public Run publishAll() {
        Arguments arguments = this.getCommandArguments().with(Argument.of((Object)"--publish-all", (Option[])new Option[0]));
        return new Run(arguments, this.imageArgument, this.environmentVariables);
    }

    public Run publish(Object ... portMappings) {
        if (portMappings.length == 0) {
            return this;
        }
        return this.publish(Arrays.asList(portMappings));
    }

    public Run publish(Collection<?> portMappings) {
        if (portMappings == null || portMappings.isEmpty()) {
            return this;
        }
        Arguments arguments = this.getCommandArguments().with(Argument.of((String)"--publish", (char)'=', (Object)new Argument.Multiple(portMappings), (Option[])new Option[0]));
        return new Run(arguments, this.imageArgument, this.environmentVariables);
    }

    public Run autoRemove() {
        return this.withCommandArguments(Argument.of((Object)"--rm", (Option[])new Option[0]));
    }

    public Run attach() {
        Argument argument = Argument.of((Object)"--attach", (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run addHost(Object ... hostMappings) {
        Argument argument = Argument.of((String)"--add-host", (char)'=', (Object)new Argument.Multiple(hostMappings), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run blockIOWeight(int weight) {
        Argument argument = Argument.of((String)"--blkio-weight", (char)'=', (Object)weight, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run blockIOWeightDevice(int weight) {
        Argument argument = Argument.of((String)"--blkio-weight-device", (char)'=', (Object)weight, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cpuShares(int weight) {
        return new Run(this.getCommandArguments().replace(Argument.of((String)"--cpu-shares", (char)'=', (Object)weight, (Option[])new Option[0])), this.imageArgument, this.environmentVariables);
    }

    public Run addCapability(Object ... capabilities) {
        Argument argument = Argument.of((String)"--cap-add", (char)'=', (Object)new Argument.Multiple(capabilities), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run dropCapability(Object ... capabilities) {
        Argument argument = Argument.of((String)"--cap-drop", (char)'=', (Object)new Argument.Multiple(capabilities), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cgroupParent(String parent) {
        Argument argument = Argument.of((String)"--cgroup-parent", (char)'=', (Object)parent, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cidFile(File file) {
        Argument argument = Argument.of((String)"--cidfile", (char)'=', (Object)file, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cpuPeriod(int value) {
        Argument argument = Argument.of((String)"--cpu-period", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cpuQuota(int value) {
        Argument argument = Argument.of((String)"--cpu-quota", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cpuSetCPUs(String value) {
        Argument argument = Argument.of((String)"--cpuset-cpus", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run cpuSetMems(String value) {
        Argument argument = Argument.of((String)"--cpuset-mems", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run detach(String name) {
        Argument argument = Argument.of((String)"--detach", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run detachKeys(String keys) {
        Argument argument = Argument.of((String)"--detach-keys", (char)'=', (Object)keys, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run device(Object ... names) {
        Argument argument = Argument.of((String)"--device", (char)'=', (Object)new Argument.Multiple(names), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run deviceReadBytesPerSec(String ... values) {
        Argument argument = Argument.of((String)"--device-read-bps", (char)'=', (Object)new Argument.Multiple((Object[])values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run deviceReadIOPS(String ... values) {
        Argument argument = Argument.of((String)"--device-read-iops", (char)'=', (Object)new Argument.Multiple((Object[])values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run deviceWriteBytesPerSec(String ... values) {
        Argument argument = Argument.of((String)"--device-write-bps", (char)'=', (Object)new Argument.Multiple((Object[])values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run deviceWriteIOPS(String ... values) {
        Argument argument = Argument.of((String)"--device-write-iops", (char)'=', (Object)new Argument.Multiple((Object[])values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run disableContentTrust() {
        Argument argument = Argument.of((String)"--disable-content-trust", (char)'=', (Object)true, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run enableContentTrust() {
        Argument argument = Argument.of((String)"--disable-content-trust", (char)'=', (Object)false, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run dns(String ... servers) {
        Argument argument = Argument.of((String)"--dns", (char)'=', (Object)new Argument.Multiple((Object[])servers), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run dnsOptions(String ... options) {
        Argument argument = Argument.of((String)"--dns-opt", (char)'=', (Object)new Argument.Multiple((Object[])options), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run dnsSearch(String ... domains) {
        Argument argument = Argument.of((String)"--dns-search", (char)'=', (Object)new Argument.Multiple((Object[])domains), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run entryPoint(String entrypoint) {
        Argument argument = Argument.of((String)"--entrypoint", (char)'=', (Object)entrypoint, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run envFile(File file) {
        Argument argument = Argument.of((String)"--env-file", (char)'=', (Object)file, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run groupAdd(String ... groups) {
        Argument argument = Argument.of((String)"--group-add", (char)'=', (Object)new Argument.Multiple((Object[])groups), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run hostName(String name) {
        Argument argument = Argument.of((String)"--hostname", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run ip(String address) {
        Argument argument = Argument.of((String)"--ip", (char)'=', (Object)address, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run ip6(String address) {
        Argument argument = Argument.of((String)"--ip6", (char)'=', (Object)address, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run ipc(String namespace) {
        Argument argument = Argument.of((String)"--ipc", (char)'=', (Object)namespace, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run isolation(String value) {
        Argument argument = Argument.of((String)"--isolation", (char)'=', (Object)value, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run kernalMemory(String limit) {
        Argument argument = Argument.of((String)"--kernel-memory", (char)'=', (Object)limit, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run labels(Object ... values) {
        Argument argument = Argument.of((String)"--label", (char)'=', (Object)new Argument.Multiple(values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run labelFile(File ... files) {
        Argument argument = Argument.of((String)"--label-file", (char)'=', (Object)new Argument.Multiple((Object[])files), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run link(Object ... containers) {
        return this.link(Arrays.asList(containers));
    }

    public Run link(List<?> containers) {
        if (containers == null || containers.isEmpty()) {
            return this;
        }
        Argument argument = Argument.of((String)"--link", (char)'=', (Object)new Argument.Multiple(containers), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run logDriver(String name) {
        Argument argument = Argument.of((String)"--log-driver", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run logOptions(Object ... options) {
        Argument argument = Argument.of((String)"--log-opt", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run macAddress(String address) {
        Argument argument = Argument.of((String)"--mac-address", (char)'=', (Object)address, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run memory(String limit) {
        Argument argument = Argument.of((String)"--memory", (char)'=', (Object)limit, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run memoryReservation(String limit) {
        Argument argument = Argument.of((String)"--memory-reservation", (char)'=', (Object)limit, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run memorySwap(int swap) {
        Argument argument = Argument.of((String)"--memory-swap", (char)'=', (Object)swap, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run memorySwappiness(int swap) {
        Argument argument = Argument.of((String)"--memory-swappiness", (char)'=', (Object)swap, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run netNone() {
        return this.net("none");
    }

    public Run netBridge() {
        return this.net("bridge");
    }

    public Run netHost() {
        return this.net("host");
    }

    public Run netContainer(String container) {
        return this.net("container:" + container);
    }

    public Run net(String name) {
        if (name == null || name.trim().isEmpty()) {
            return this;
        }
        Argument argument = Argument.of((String)"--net", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run netAlias(String ... aliases) {
        Argument argument = Argument.of((String)"--net-alias", (char)'=', (Object)new Argument.Multiple((Object[])aliases), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run oomKillDisabled() {
        Argument argument = Argument.of((Object)"--oom-kill-disabled", (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run oomScoreAdjust(int score) {
        Argument argument = Argument.of((String)"--oom-score-adj", (char)'=', (Object)score, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run pid(String namespace) {
        Argument argument = Argument.of((String)"--pid", (char)'=', (Object)namespace, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run pidsLimit(int limit) {
        Argument argument = Argument.of((String)"--pids-limit", (char)'=', (Object)limit, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run privileged(int limit) {
        Argument argument = Argument.of((Object)"--privileged", (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run readOnly() {
        Argument argument = Argument.of((Object)"--read-only", (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run restartAlways() {
        return this.restart("always");
    }

    public Run restartNo() {
        return this.restart("no");
    }

    public Run restartOnFailure() {
        return this.restart("on-failure");
    }

    public Run restartOnFailure(int maxRetries) {
        return this.restart("on-failure");
    }

    public Run restartUnlessStopped() {
        return this.restart("unless-stopped");
    }

    public Run restart(String policy) {
        Argument argument = Argument.of((String)"--restart", (char)'=', (Object)policy, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run rm() {
        Argument argument = Argument.of((Object)"--rm", (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run shmSize(Object ... values) {
        Argument argument = Argument.of((String)"--shm-size", (char)'=', (Object)new Argument.Multiple(values), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run securityOptions(Object ... options) {
        Argument argument = Argument.of((String)"--security-opt", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run signalProxy(boolean enabled) {
        Argument argument = Argument.of((String)"--sig-proxy", (char)'=', (Object)enabled, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run stopSignal(String signal) {
        Argument argument = Argument.of((String)"--stop-signal", (char)'=', (Object)signal, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run user(String username) {
        Argument argument = Argument.of((String)"--user", (char)'=', (Object)username, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run userNamespace(String namespace) {
        Argument argument = Argument.of((String)"--userns", (char)'=', (Object)namespace, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run ulimit(Object ... options) {
        Argument argument = Argument.of((String)"--ulimit", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run utsNamespace(Object ... options) {
        Argument argument = Argument.of((String)"--ulimit", (char)'=', (Object)new Argument.Multiple(options), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run volume(Object ... volumes) {
        Argument argument = Argument.of((String)"--volume", (char)'=', (Object)new Argument.Multiple(volumes), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run volumeDriver(String name) {
        Argument argument = Argument.of((String)"--volume-driver", (char)'=', (Object)name, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run volumesFrom(String ... containers) {
        Argument argument = Argument.of((String)"--volumes-from", (char)'=', (Object)new Argument.Multiple((Object[])containers), (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    public Run workinDirectory(File file) {
        Argument argument = Argument.of((String)"--workdir", (char)'=', (Object)file, (Option[])new Option[0]);
        return new Run(this.getCommandArguments().replace(argument), this.imageArgument, this.environmentVariables);
    }

    @Override
    public void onLaunch(Platform platform, OptionsByType optionsByType) {
        Arguments currentArguments = (Arguments)optionsByType.get(Arguments.class, new Object[0]);
        super.onLaunch(platform, optionsByType);
        EnvironmentVariables envVars = EnvironmentVariables.custom().with(this.environmentVariables);
        Properties variables = envVars.realize(platform, optionsByType.asArray());
        variables.entrySet().stream().map(entry -> {
            if (entry.getValue() == null) {
                return entry.getKey().toString();
            }
            return entry.getKey() + "=" + entry.getValue();
        }).map(value -> Argument.of((String)"--env", (Object)value, (Option[])new Option[0])).forEach(arg_0 -> ((OptionsByType)optionsByType).add(arg_0));
        optionsByType.add((Option)this.imageArgument);
        currentArguments.forEach(arg_0 -> ((OptionsByType)optionsByType).add(arg_0));
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
        String name = this.getCommandArguments().stream().filter(arg -> arg.getName() != null && arg.getName().equals("--name")).map(arg -> String.valueOf(arg.getValue())).findFirst().orElse(null);
        DockerContainer container = new DockerContainer(name, optionsByType);
        application.add((Object)container);
    }

    public static Run image(String image) {
        return Run.image(image, (Object)UUID.randomUUID().toString());
    }

    public static Run image(String image, Object containerName) {
        return new Run(image, containerName);
    }

    public static Run image(DockerImage image) {
        return Run.image(image.getFirstTag(), (Object)UUID.randomUUID().toString());
    }

    public static Run image(DockerImage image, Object containerName) {
        return new Run(image.getFirstTag(), containerName);
    }
}

