/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.machine;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.docker.machine.DockerMachine;
import com.oracle.bedrock.runtime.docker.machine.DockerMachinePlatform;
import java.util.function.Consumer;

public class MachineCloseBehaviour
implements Option,
Consumer<DockerMachinePlatform> {
    private final Consumer<DockerMachinePlatform> action;

    private MachineCloseBehaviour(Consumer<DockerMachinePlatform> action) {
        this.action = action;
    }

    @Override
    public void accept(DockerMachinePlatform platform) {
        this.action.accept(platform);
    }

    private static void stopOrKill(DockerMachinePlatform platform) {
        int exit;
        DockerMachine machine = platform.getDockerMachine();
        String name = platform.getName();
        try {
            exit = machine.stop(name);
        }
        catch (Throwable _ignored) {
            exit = -1;
        }
        if (exit != 0) {
            machine.kill(name);
        }
    }

    private static void remove(DockerMachinePlatform platform) {
        DockerMachine machine = platform.getDockerMachine();
        String name = platform.getName();
        MachineCloseBehaviour.stopOrKill(platform);
        machine.remove(true, name);
    }

    public static MachineCloseBehaviour none() {
        return new MachineCloseBehaviour(platform -> {});
    }

    public static MachineCloseBehaviour stop() {
        return new MachineCloseBehaviour(MachineCloseBehaviour::stopOrKill);
    }

    @OptionsByType.Default
    public static MachineCloseBehaviour remove() {
        return new MachineCloseBehaviour(MachineCloseBehaviour::remove);
    }
}

