/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.jacoco;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.jacoco.Dump;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.options.JavaAgent;
import java.util.concurrent.CompletableFuture;
import org.jacoco.agent.rt.RT;

public class JacocoProfile
implements Profile,
Option {
    private String parameters;

    @OptionsByType.Default
    public JacocoProfile(String parameters) {
        this.parameters = parameters;
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (metaClass != null && JavaApplication.class.isAssignableFrom(metaClass.getImplementationClass(platform, optionsByType))) {
            try {
                ClassPath jacocoPath = ClassPath.ofClass(RT.class);
                JavaAgent javaAgent = JavaAgent.using((String)jacocoPath.toString(), (String)this.parameters);
                optionsByType.add((Option)javaAgent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
        if (application instanceof JavaApplication) {
            JavaApplication javaApplication = (JavaApplication)application;
            CompletableFuture future = javaApplication.submit((RemoteCallable)new Dump(), new Option[0]);
            future.join();
        }
    }
}

