/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.AbstractAssembly;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.AssemblyBuilder;
import com.oracle.bedrock.runtime.Infrastructure;
import java.util.LinkedList;

@Internal
public abstract class AbstractAssemblyBuilder<A extends Application, G extends AbstractAssembly<A>>
implements AssemblyBuilder<A, G> {
    protected LinkedList<Characteristics> characteristics = new LinkedList();
    protected OptionsByType optionsByType = OptionsByType.empty();

    @Override
    public void with(Option ... options) {
        this.optionsByType = OptionsByType.of((Option[])options);
    }

    @Override
    public void include(int count, Class<? extends A> applicationClass, Option ... options) {
        if (count > 0) {
            this.characteristics.add(new Characteristics<A>(count, applicationClass, options));
        }
    }

    @Override
    public G build(Infrastructure infrastructure, Option ... options) {
        G assembly = this.createAssembly(OptionsByType.of((OptionsByType)this.optionsByType));
        for (Characteristics characteristic : this.characteristics) {
            int instanceCount = characteristic.getCount();
            Class applicationClass = characteristic.getApplicationClass();
            OptionsByType launchOptions = OptionsByType.of((Option[])characteristic.getOptions()).addAll(options);
            ((AbstractAssembly)assembly).expand(instanceCount, infrastructure, applicationClass, launchOptions.asArray());
        }
        return assembly;
    }

    protected abstract G createAssembly(OptionsByType var1);

    protected static class Characteristics<A extends Application> {
        private int count;
        private Class<? extends A> applicationClass;
        private Option[] options;

        public Characteristics(int count, Class<? extends A> applicationClass, Option ... options) {
            this.count = count;
            this.applicationClass = applicationClass;
            this.options = options;
        }

        public int getCount() {
            return this.count;
        }

        public Class<? extends A> getApplicationClass() {
            return this.applicationClass;
        }

        public Option[] getOptions() {
            return this.options;
        }
    }
}

