/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.concurrent.ControllableRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteChannelListener;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.options.StreamName;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

@Internal
public abstract class AbstractControllableRemoteChannel
implements ControllableRemoteChannel {
    private volatile boolean isOpen = false;
    protected CopyOnWriteArraySet<RemoteChannelListener> channelListeners = new CopyOnWriteArraySet();
    protected ConcurrentHashMap<StreamName, CopyOnWriteArraySet<RemoteEventListener>> eventListenersByStreamName = new ConcurrentHashMap();

    protected synchronized void setOpen(boolean isOpen) {
        this.isOpen = true;
    }

    @Override
    public final synchronized void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.onClose();
            for (RemoteChannelListener listener : this.channelListeners) {
                try {
                    listener.onClosed(this);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    public void injectInto(Object object) {
        if (object != null) {
            try {
                int modifiers;
                Class<?> objectClass = object.getClass();
                ClassLoader loader = objectClass.getClassLoader();
                Class<?> annotationClass = loader.loadClass(RemoteChannel.Inject.class.getName());
                Class<?> channelClass = this.getClass();
                for (Method method : objectClass.getDeclaredMethods()) {
                    modifiers = method.getModifiers();
                    if (method.getAnnotation(annotationClass) == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(channelClass) || !Modifier.isPublic(modifiers)) continue;
                    try {
                        method.invoke(object, this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (AccessibleObject accessibleObject : objectClass.getDeclaredFields()) {
                    modifiers = ((Field)accessibleObject).getModifiers();
                    if (((Field)accessibleObject).getAnnotation(annotationClass) == null || Modifier.isStatic(modifiers) || !((Field)accessibleObject).getType().isAssignableFrom(channelClass)) continue;
                    try {
                        try {
                            ((Field)accessibleObject).setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((Field)accessibleObject).set(object, this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void addListener(RemoteChannelListener listener) {
        this.channelListeners.add(listener);
    }

    @Override
    public void addListener(RemoteEventListener listener, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        StreamName streamName = (StreamName)optionsByType.get(StreamName.class, new Object[0]);
        this.eventListenersByStreamName.compute(streamName, (name, eventListeners) -> {
            if (eventListeners == null) {
                eventListeners = new CopyOnWriteArraySet<RemoteEventListener>();
            }
            eventListeners.add(listener);
            return eventListeners;
        });
    }

    @Override
    public void removeListener(RemoteEventListener listener, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        StreamName streamName = (StreamName)optionsByType.get(StreamName.class, new Object[0]);
        this.eventListenersByStreamName.computeIfPresent(streamName, (name, eventListeners) -> {
            eventListeners.remove(listener);
            return eventListeners.size() == 0 ? null : eventListeners;
        });
    }

    protected abstract void onClose();
}

