/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaModules
implements ComposableOption<JavaModules>,
JvmOption {
    private final boolean enabled;
    private final Set<String> modules;
    private final Set<String> exports;
    private final Set<String> patches;
    private final Set<String> reading;

    private JavaModules(boolean enabled, Set<String> modules, Set<String> exports, Set<String> patches, Set<String> reading) {
        this.enabled = enabled;
        this.modules = modules;
        this.exports = exports;
        this.patches = patches;
        this.reading = reading;
    }

    public static JavaModules enabled() {
        return new JavaModules(true, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    @OptionsByType.Default
    public static JavaModules disabled() {
        return new JavaModules(false, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public JavaModules adding(String ... modules) {
        if (modules.length == 0) {
            return this;
        }
        return new JavaModules(true, JavaModules.toSet(this.modules, modules), this.exports, this.patches, this.reading);
    }

    public JavaModules exporting(String ... exports) {
        return new JavaModules(true, this.modules, JavaModules.toSet(this.exports, exports), this.patches, this.reading);
    }

    public JavaModules exportingTo(String toModule, String ... modules) {
        if (modules.length == 0) {
            return this;
        }
        LinkedHashSet<String> exports = new LinkedHashSet<String>(this.exports);
        Arrays.stream(modules).map(m -> m + "/" + m + "=" + toModule).forEach(exports::add);
        return new JavaModules(true, this.modules, exports, this.patches, this.reading);
    }

    public JavaModules exportingToBedrock(String ... modules) {
        return this.exportingTo("com.oracle.bedrock.runtime", modules);
    }

    public JavaModules patching(String ... patches) {
        if (patches.length == 0) {
            return this;
        }
        return new JavaModules(true, this.modules, this.exports, JavaModules.toSet(this.patches, patches), this.reading);
    }

    public JavaModules reading(String ... reads) {
        if (reads.length == 0) {
            return this;
        }
        return new JavaModules(true, this.modules, this.exports, this.patches, JavaModules.toSet(this.reading, reads));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static Set<String> toSet(Set<String> set, String[] modules) {
        Set<String> moduleSet;
        if (modules == null || modules.length == 0) {
            moduleSet = set;
        } else {
            moduleSet = new LinkedHashSet<String>(set);
            Arrays.stream(modules).filter(Objects::nonNull).forEach(moduleSet::add);
        }
        return moduleSet;
    }

    public JavaModules compose(JavaModules other) {
        LinkedHashSet<String> setAdd = new LinkedHashSet<String>(this.modules);
        LinkedHashSet<String> setExport = new LinkedHashSet<String>(this.exports);
        LinkedHashSet<String> setPatch = new LinkedHashSet<String>(this.patches);
        LinkedHashSet<String> setReads = new LinkedHashSet<String>(this.reading);
        setAdd.addAll(other.modules);
        setExport.addAll(other.exports);
        setPatch.addAll(other.patches);
        setReads.addAll(other.reading);
        boolean isEnabled = this.enabled && other.enabled;
        return new JavaModules(isEnabled, setAdd, setExport, setPatch, setReads);
    }

    @Override
    public Iterable<String> resolve(OptionsByType optionsByType) {
        ArrayList<String> opts = new ArrayList<String>();
        if (this.enabled) {
            if (this.modules.size() > 0) {
                opts.add("--add-modules");
                opts.add(this.modules.stream().collect(Collectors.joining(",")));
            }
            if (this.exports.size() > 0) {
                opts.add("--add-exports");
                opts.add(this.exports.stream().collect(Collectors.joining(",")));
            }
            for (String patch : this.patches) {
                opts.add("--patch-module");
                opts.add(patch);
            }
            if (this.reading.size() > 0) {
                opts.add("--add-reads");
                opts.add(this.reading.stream().collect(Collectors.joining(",")));
            }
        }
        return opts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaModules modules1 = (JavaModules)o;
        if (this.enabled != modules1.enabled) {
            return false;
        }
        if (this.modules != null ? !this.modules.equals(modules1.modules) : modules1.modules != null) {
            return false;
        }
        if (this.exports != null ? !this.exports.equals(modules1.exports) : modules1.exports != null) {
            return false;
        }
        if (this.patches != null ? !this.patches.equals(modules1.patches) : modules1.patches != null) {
            return false;
        }
        return this.reading != null ? this.reading.equals(modules1.reading) : modules1.reading == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.modules != null ? this.modules.hashCode() : 0);
        result = 31 * result + (this.exports != null ? this.exports.hashCode() : 0);
        result = 31 * result + (this.patches != null ? this.patches.hashCode() : 0);
        result = 31 * result + (this.reading != null ? this.reading.hashCode() : 0);
        return result;
    }
}

