/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.oracle.cloud.cache.ServerCacheMetrics;
import com.oracle.cloud.cache.basic.Cache;
import com.oracle.cloud.cache.basic.CacheLoader;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.Expiry;
import com.oracle.cloud.cache.basic.options.GetOption;
import com.oracle.cloud.cache.basic.options.PutOption;
import com.oracle.cloud.cache.basic.options.RemoveOption;
import com.oracle.cloud.cache.basic.options.ReplaceOption;
import com.oracle.cloud.cache.basic.options.Return;
import com.oracle.cloud.cache.basic.options.ValueType;
import com.oracle.cloud.cache.metrics.CacheMetrics;
import com.oracle.cloud.cache.util.Options;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCache<V>
implements Cache<V> {
    private final String cacheName;
    private MetricRegistry metrics;
    private final Options<CacheOption> options;
    private final Class<V> valueClass;
    private final CacheLoader<V> cacheLoader;

    protected AbstractCache(String cacheName, CacheOption ... options) {
        this.cacheName = cacheName;
        this.metrics = this.createMetrics();
        this.options = Options.from(CacheOption.class, options);
        this.valueClass = this.options.get(ValueType.class).getType();
        this.cacheLoader = this.options.get(CacheLoader.class);
    }

    protected abstract V get(String var1);

    protected abstract V put(String var1, V var2, Expiry var3, boolean var4);

    protected abstract V putIfAbsent(String var1, V var2, Expiry var3, boolean var4);

    protected abstract V replace(String var1, V var2, Expiry var3, boolean var4);

    protected abstract boolean replaceValue(String var1, V var2, V var3, Expiry var4);

    protected abstract V remove(String var1, boolean var2);

    protected abstract boolean removeValue(String var1, V var2);

    protected abstract ServerCacheMetrics getServerMetrics();

    @Override
    public V get(String key, GetOption ... options) {
        Options<GetOption> opts = Options.from(GetOption.class, options);
        Expiry expiry = opts.get(Expiry.class, this.options.get(Expiry.class, Expiry.never()));
        long startTime = System.nanoTime();
        V value = this.get(key);
        if (value == null) {
            this.registerMiss(startTime);
            if (this.cacheLoader != null) {
                startTime = System.nanoTime();
                value = this.cacheLoader.load(key);
                this.registerLoad(startTime);
                if (value != null) {
                    V currentValue = this.putIfAbsent(key, value, expiry, Return.oldValue());
                    return currentValue == null ? value : currentValue;
                }
            }
            return null;
        }
        this.registerHit(startTime);
        return value;
    }

    @Override
    public V put(String key, V value, PutOption ... options) {
        Options<PutOption> opts = Options.from(PutOption.class, options);
        Expiry expiry = opts.get(Expiry.class, this.options.get(Expiry.class, Expiry.never()));
        boolean returnOld = opts.get(Return.class).value();
        long startTime = System.nanoTime();
        V oldValue = this.put(key, value, expiry, returnOld);
        this.registerPut(startTime);
        return oldValue;
    }

    @Override
    public V putIfAbsent(String key, V value, PutOption ... options) {
        Options<PutOption> opts = Options.from(PutOption.class, options);
        Expiry expiry = opts.get(Expiry.class, this.options.get(Expiry.class, Expiry.never()));
        boolean returnOld = opts.get(Return.class).value();
        long startTime = System.nanoTime();
        V currentValue = this.putIfAbsent(key, value, expiry, returnOld);
        this.registerPut(startTime);
        return currentValue;
    }

    @Override
    public V replace(String key, V value, ReplaceOption ... options) {
        Options<ReplaceOption> opts = Options.from(ReplaceOption.class, options);
        Expiry expiry = opts.get(Expiry.class, this.options.get(Expiry.class, Expiry.never()));
        boolean returnOld = opts.get(Return.class).value();
        long startTime = System.nanoTime();
        V oldValue = this.replace(key, value, expiry, returnOld);
        this.registerPut(startTime);
        return oldValue;
    }

    @Override
    public boolean replace(String key, V valueOld, V valueNew, ReplaceOption ... options) {
        Options<ReplaceOption> opts = Options.from(ReplaceOption.class, options);
        Expiry expiry = opts.get(Expiry.class, this.options.get(Expiry.class, Expiry.never()));
        long startTime = System.nanoTime();
        boolean replaced = this.replaceValue(key, valueOld, valueNew, expiry);
        this.registerPut(startTime);
        return replaced;
    }

    @Override
    public V remove(String key, RemoveOption ... options) {
        Options<RemoveOption> opts = Options.from(RemoveOption.class, options);
        boolean returnOld = opts.get(Return.class).value();
        long startTime = System.nanoTime();
        V oldValue = this.remove(key, returnOld);
        this.registerRemove(startTime);
        return oldValue;
    }

    @Override
    public boolean remove(String key, V value, RemoveOption ... options) {
        long startTime = System.nanoTime();
        boolean fRemoved = this.removeValue(key, value);
        this.registerRemove(startTime);
        return fRemoved;
    }

    @Override
    public CacheMetrics getMetrics() {
        return new CacheMetrics(this.getCacheName(), this.metrics);
    }

    @Override
    public void resetMetrics() {
        this.metrics = this.createMetrics();
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected Class<V> getValueClass() {
        return this.valueClass;
    }

    protected Options<CacheOption> getOptions() {
        return this.options;
    }

    protected MetricRegistry createMetrics() {
        MetricRegistry metrics = new MetricRegistry();
        metrics.register("get", (Metric)new Timer());
        metrics.register("put", (Metric)new Timer());
        metrics.register("remove", (Metric)new Timer());
        metrics.register("load", (Metric)new Timer());
        metrics.register("hit", (Metric)new Counter());
        metrics.register("miss", (Metric)new Counter());
        metrics.register("count", (Metric)((Gauge)() -> this.getServerMetrics().getCount()));
        metrics.register("size", (Metric)((Gauge)() -> this.getServerMetrics().getSize()));
        return metrics;
    }

    protected void registerHit(long startTime) {
        long duration = this.duration(startTime);
        this.metrics.timer("get").update(duration, TimeUnit.NANOSECONDS);
        this.metrics.counter("hit").inc();
    }

    protected void registerMiss(long startTime) {
        long duration = this.duration(startTime);
        this.metrics.timer("get").update(duration, TimeUnit.NANOSECONDS);
        this.metrics.counter("miss").inc();
    }

    protected void registerPut(long startTime) {
        this.metrics.timer("put").update(this.duration(startTime), TimeUnit.NANOSECONDS);
    }

    protected void registerRemove(long startTime) {
        this.metrics.timer("remove").update(this.duration(startTime), TimeUnit.NANOSECONDS);
    }

    protected void registerLoad(long startTime) {
        this.metrics.timer("load").update(this.duration(startTime), TimeUnit.NANOSECONDS);
    }

    protected long duration(long startTime) {
        return Math.max(0L, System.nanoTime() - startTime);
    }
}

