/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.google.protobuf.ByteString;
import com.oracle.cloud.cache.ServerCacheMetrics;
import com.oracle.cloud.cache.basic.AbstractCache;
import com.oracle.cloud.cache.basic.CacheGrpc;
import com.oracle.cloud.cache.basic.CacheProtocol;
import com.oracle.cloud.cache.basic.CacheRpc;
import com.oracle.cloud.cache.basic.GrpcSession;
import com.oracle.cloud.cache.basic.io.Serializer;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.Expiry;
import io.grpc.Channel;
import java.io.IOException;

public class GrpcCache<V>
extends AbstractCache<V> {
    private final GrpcSession grpcSession;
    private final CacheGrpc.CacheBlockingStub client;
    private final Serializer serializer;

    GrpcCache(String cacheName, GrpcSession grpcSession, CacheOption ... options) {
        super(cacheName, options);
        this.grpcSession = grpcSession;
        this.serializer = this.getOptions().get(Serializer.class, grpcSession.getOptions().get(Serializer.class));
        this.client = CacheGrpc.newBlockingStub((Channel)grpcSession.getChannel());
    }

    @Override
    protected V get(String key) {
        try {
            CacheRpc.GetResponse response = this.client.get(CacheProtocol.getRequest((String)this.getCacheName(), (String)key));
            ByteString byteString = response.getValue();
            return this.serializer.deserialize(byteString.toByteArray(), this.getValueClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V put(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            CacheRpc.PutResponse response = this.client.put(CacheProtocol.putRequest((String)this.getCacheName(), (String)key, (byte[])this.serializer.serialize(value), (long)expiry.getExpiry(), (boolean)returnOld));
            return returnOld ? (V)this.serializer.deserialize(response.getValue().toByteArray(), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V putIfAbsent(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            CacheRpc.PutResponse response = this.client.putIfAbsent(CacheProtocol.putRequest((String)this.getCacheName(), (String)key, (byte[])this.serializer.serialize(value), (long)expiry.getExpiry(), (boolean)returnOld));
            ByteString byteString = response.getValue();
            return returnOld && byteString != null && byteString.size() > 0 ? (V)this.serializer.deserialize(byteString.toByteArray(), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V replace(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            CacheRpc.ReplaceResponse response = this.client.replace(CacheProtocol.replaceRequest((String)this.getCacheName(), (String)key, (byte[])this.serializer.serialize(value), (long)expiry.getExpiry(), (boolean)returnOld));
            return returnOld ? (V)this.serializer.deserialize(response.getValue().toByteArray(), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean replaceValue(String key, V valueOld, V valueNew, Expiry expiry) {
        try {
            CacheRpc.ReplaceValueResponse response = this.client.replaceValue(CacheProtocol.replaceValueRequest((String)this.getCacheName(), (String)key, (byte[])this.serializer.serialize(valueOld), (byte[])this.serializer.serialize(valueNew), (long)expiry.getExpiry()));
            return response.getSuccess();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V remove(String key, boolean returnOld) {
        try {
            CacheRpc.RemoveResponse response = this.client.remove(CacheProtocol.removeRequest((String)this.getCacheName(), (String)key, (boolean)returnOld));
            return returnOld ? (V)this.serializer.deserialize(response.getValue().toByteArray(), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean removeValue(String key, V value) {
        try {
            CacheRpc.RemoveValueResponse response = this.client.removeValue(CacheProtocol.removeValueRequest((String)this.getCacheName(), (String)key, (byte[])this.serializer.serialize(value)));
            return response.getSuccess();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ServerCacheMetrics getServerMetrics() {
        CacheRpc.MetricsResponse response = this.client.getMetrics(CacheProtocol.metricsRequest((String)this.getCacheName()));
        return new ServerCacheMetrics(response.getCount(), response.getSize());
    }

    @Override
    public void clear() {
        this.client.clear(CacheProtocol.clearRequest((String)this.getCacheName()));
    }
}

