/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.oracle.cloud.cache.basic.Cache;
import com.oracle.cloud.cache.basic.GrpcCache;
import com.oracle.cloud.cache.basic.Session;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.SessionOption;
import com.oracle.cloud.cache.util.Options;
import io.grpc.Channel;
import io.grpc.netty.NettyChannelBuilder;
import java.net.URI;
import java.util.Arrays;

public class GrpcSession
implements Session {
    private final URI uri;
    private final Options<SessionOption> options;
    private Channel channel;

    public GrpcSession(URI uri, SessionOption ... options) {
        this.uri = uri;
        this.options = Options.from(SessionOption.class, options);
        this.channel = this.createChannel();
    }

    private Channel createChannel() {
        if (this.uri == null) {
            throw new IllegalArgumentException("URI must be specified");
        }
        return ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)this.uri.getHost(), (int)this.uri.getPort()).maxInboundMessageSize(GrpcSession.getMaxMessageSize())).usePlaintext(true).build();
    }

    @Override
    public <V> Cache<V> getCache(String cacheName, CacheOption ... options) {
        return new GrpcCache(cacheName, this, options);
    }

    public Options<SessionOption> getOptions() {
        return this.options;
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String toString() {
        return "GrpcSession{uri=" + this.uri + ", options=" + Arrays.toString(this.options.asArray()) + '}';
    }

    static int getMaxMessageSize() {
        String propertyName = "ccs.maxMessageSizeMB";
        int max = Integer.parseInt(System.getProperty("ccs.maxMessageSizeMB", "4"));
        if (max >= 256) {
            throw new IllegalArgumentException("Value for ccs.maxMessageSizeMB must be less tha 256");
        }
        return max * 1024 * 1024;
    }
}

