/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.oracle.cloud.cache.ServerCacheMetrics;
import com.oracle.cloud.cache.basic.AbstractCache;
import com.oracle.cloud.cache.basic.LocalSession;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.Expiry;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class LocalCache<V>
extends AbstractCache<V> {
    private static final long NO_EXPIRY = -1L;
    private final ConcurrentHashMap<String, ExpiringValue<V>> mapLocalCache = new ConcurrentHashMap();
    private long nextFlush = 0L;
    private final LocalSession session;

    LocalCache(String cacheName, LocalSession session, CacheOption ... options) {
        super(cacheName, options);
        this.session = session;
    }

    @Override
    protected V get(String key) {
        this.evict();
        ExpiringValue<V> expiringValue = this.mapLocalCache.get(key);
        return expiringValue == null ? null : (V)expiringValue.getValue();
    }

    @Override
    protected V put(String key, V value, Expiry expiry, boolean returnOld) {
        this.evict();
        ExpiringValue oldValue = this.mapLocalCache.put(key, new ExpiringValue(value, expiry.getExpiry()));
        return returnOld ? (oldValue == null ? null : oldValue.getValue()) : null;
    }

    @Override
    protected V putIfAbsent(String key, V value, Expiry expiry, boolean returnOld) {
        this.evict();
        ExpiringValue oldValue = this.mapLocalCache.putIfAbsent(key, new ExpiringValue(value, expiry.getExpiry()));
        return returnOld ? (oldValue == null ? null : oldValue.getValue()) : null;
    }

    @Override
    protected V replace(String key, V value, Expiry expiry, boolean returnOld) {
        this.evict();
        ExpiringValue oldValue = this.mapLocalCache.replace(key, new ExpiringValue(value, expiry.getExpiry()));
        return returnOld ? (oldValue == null ? null : oldValue.getValue()) : null;
    }

    @Override
    protected boolean replaceValue(String key, V valueOld, V valueNew, Expiry expiry) {
        this.evict();
        long expiryTime = expiry.getExpiry();
        return this.mapLocalCache.replace(key, new ExpiringValue(valueOld, expiryTime), new ExpiringValue(valueNew, expiryTime));
    }

    @Override
    protected V remove(String key, boolean returnOld) {
        this.evict();
        ExpiringValue<V> oldValue = this.mapLocalCache.remove(key);
        return returnOld ? (oldValue == null ? null : oldValue.getValue()) : null;
    }

    @Override
    protected boolean removeValue(String key, V value) {
        return this.mapLocalCache.remove(key, new ExpiringValue(value, 0L));
    }

    @Override
    protected ServerCacheMetrics getServerMetrics() {
        return new ServerCacheMetrics((long)this.mapLocalCache.size(), -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LocalCache localCache = this;
        synchronized (localCache) {
            this.mapLocalCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        long current = System.currentTimeMillis();
        LocalCache localCache = this;
        synchronized (localCache) {
            if (current > this.nextFlush) {
                this.nextFlush = System.currentTimeMillis();
                try {
                    HashSet entries = new HashSet();
                    this.mapLocalCache.forEach((k, v) -> {
                        long expiryTime = v.getExpiry();
                        if (expiryTime != -1L && expiryTime < System.currentTimeMillis()) {
                            entries.add(k);
                        }
                    });
                    entries.forEach(k -> this.mapLocalCache.remove(k));
                }
                finally {
                    this.nextFlush = System.currentTimeMillis() + 50L;
                }
            }
        }
    }

    private static class ExpiringValue<V> {
        private final V value;
        private final long expiryTime;

        private ExpiringValue(V value, long expiryTime) {
            this.value = value;
            this.expiryTime = expiryTime;
        }

        public ExpiringValue of(V value, long expiryTime) {
            return new ExpiringValue<V>(value, expiryTime == -1L ? -1L : System.currentTimeMillis() + expiryTime);
        }

        public V getValue() {
            return this.value;
        }

        public long getExpiry() {
            return this.expiryTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiringValue that = (ExpiringValue)o;
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public String toString() {
            return "ExpiringValue{value=" + this.value + ", expiryTime=" + this.expiryTime + '}';
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

