/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.oracle.cloud.cache.basic.GrpcSession;
import com.oracle.cloud.cache.basic.RestSession;
import com.oracle.cloud.cache.basic.Session;
import com.oracle.cloud.cache.basic.SessionProvider;
import com.oracle.cloud.cache.basic.options.SessionOption;
import com.oracle.cloud.cache.basic.options.Transport;
import com.oracle.cloud.cache.util.Options;
import java.net.URI;
import java.net.URISyntaxException;

public class RemoteSessionProvider
implements SessionProvider {
    private URI uri;

    public RemoteSessionProvider() {
        this(System.getProperty("cloud.cache.uri", "http://localhost:1444/"));
    }

    public RemoteSessionProvider(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid URI", e);
        }
    }

    public RemoteSessionProvider(URI uri) {
        this.uri = uri;
    }

    @Override
    public Session createSession(SessionOption ... options) {
        Transport transport = Options.from(SessionOption.class, options).get(Transport.class);
        return transport.getType() == Transport.Type.GRPC ? new GrpcSession(this.uri, options) : new RestSession(this.uri, options);
    }

    public URI getUri() {
        return this.uri;
    }
}

