/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.oracle.cloud.cache.ServerCacheMetrics;
import com.oracle.cloud.cache.basic.AbstractCache;
import com.oracle.cloud.cache.basic.RestSession;
import com.oracle.cloud.cache.basic.io.Serializer;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.Expiry;
import com.oracle.cloud.cache.rest.MultiValue;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class RestCache<V>
extends AbstractCache<V> {
    private static final SecurityException SECURITY_EXCEPTION = new SecurityException("Server responded with HTTP 403 (Forbidden)");
    private final RestSession restSession;
    private final WebTarget cache;
    private final Serializer serializer;

    public RestCache(String cacheName, RestSession session, CacheOption ... options) {
        super(cacheName, options);
        this.restSession = session;
        this.serializer = this.getOptions().get(Serializer.class, session.getOptions().get(Serializer.class));
        this.cache = session.getTarget().path(cacheName);
    }

    @Override
    protected V get(String key) {
        try {
            Response response = this.cache.path(key).request(new String[]{"application/octet-stream"}).get();
            RestCache.validateResponse(response.getStatus(), Response.Status.OK.getStatusCode(), Response.Status.NOT_FOUND.getStatusCode());
            return response.getStatus() == Response.Status.OK.getStatusCode() ? (V)this.serializer.deserialize((byte[])response.readEntity(byte[].class), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V put(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            Response response = this.cache.path(key).queryParam("ttl", new Object[]{expiry.getExpiry()}).queryParam("returnOld", new Object[]{returnOld}).request(new String[]{"application/octet-stream"}).put(Entity.entity((Object)this.serializer.serialize(value), (String)"application/octet-stream"));
            RestCache.validateResponse(response.getStatus(), Response.Status.OK.getStatusCode(), Response.Status.NO_CONTENT.getStatusCode());
            return response.getStatus() == Response.Status.OK.getStatusCode() ? (V)this.serializer.deserialize((byte[])response.readEntity(byte[].class), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V putIfAbsent(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            Response response = this.cache.path(key).queryParam("ttl", new Object[]{expiry.getExpiry()}).queryParam("returnOld", new Object[]{returnOld}).request(new String[]{"application/octet-stream"}).header("X-Method", (Object)"putIfAbsent").post(Entity.entity((Object)this.serializer.serialize(value), (String)"application/octet-stream"));
            RestCache.validateResponse(response.getStatus(), Response.Status.CONFLICT.getStatusCode(), Response.Status.NO_CONTENT.getStatusCode());
            return response.getStatus() == Response.Status.CONFLICT.getStatusCode() ? (V)this.serializer.deserialize((byte[])response.readEntity(byte[].class), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V replace(String key, V value, Expiry expiry, boolean returnOld) {
        try {
            Response response = this.cache.path(key).queryParam("ttl", new Object[]{expiry.getExpiry()}).queryParam("returnOld", new Object[]{returnOld}).request(new String[]{"application/octet-stream"}).header("X-Method", (Object)"replace").post(Entity.entity((Object)this.serializer.serialize(value), (String)"application/octet-stream"));
            RestCache.validateResponse(response.getStatus(), Response.Status.NO_CONTENT.getStatusCode(), Response.Status.OK.getStatusCode());
            return response.getStatus() == Response.Status.OK.getStatusCode() ? (V)this.serializer.deserialize((byte[])response.readEntity(byte[].class), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean replaceValue(String key, V valueOld, V valueNew, Expiry expiry) {
        try {
            Response response = this.cache.path(key).queryParam("ttl", new Object[]{expiry.getExpiry()}).request(new String[]{"application/octet-stream"}).header("X-Method", (Object)"replaceValue").post(Entity.entity((Object)new MultiValue((byte[][])new byte[][]{this.serializer.serialize(valueOld), this.serializer.serialize(valueNew)}), (String)"application/x-multivalue-octet-stream"));
            RestCache.validateResponse(response.getStatus(), Response.Status.NO_CONTENT.getStatusCode(), Response.Status.CONFLICT.getStatusCode());
            return response.getStatus() == Response.Status.NO_CONTENT.getStatusCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected V remove(String key, boolean returnOld) {
        try {
            Response response = this.cache.path(key).queryParam("returnOld", new Object[]{returnOld}).request().delete();
            RestCache.validateResponse(response.getStatus(), Response.Status.OK.getStatusCode(), Response.Status.NO_CONTENT.getStatusCode());
            return response.getStatus() == Response.Status.OK.getStatusCode() ? (V)this.serializer.deserialize((byte[])response.readEntity(byte[].class), this.getValueClass()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean removeValue(String key, V value) {
        try {
            Response response = this.cache.path(key).request(new String[]{"application/octet-stream"}).header("X-Method", (Object)"removeValue").post(Entity.entity((Object)this.serializer.serialize(value), (String)"application/octet-stream"));
            RestCache.validateResponse(response.getStatus(), Response.Status.CONFLICT.getStatusCode(), Response.Status.NO_CONTENT.getStatusCode());
            return response.getStatus() == Response.Status.NO_CONTENT.getStatusCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ServerCacheMetrics getServerMetrics() {
        Response response = this.cache.request(new String[]{"application/json"}).get();
        RestCache.validateResponse(response.getStatus(), Response.Status.OK.getStatusCode());
        return response.getStatus() == Response.Status.OK.getStatusCode() ? (ServerCacheMetrics)response.readEntity(ServerCacheMetrics.class) : null;
    }

    @Override
    public void clear() {
        Response response = this.cache.request().delete();
        RestCache.validateResponse(response.getStatus(), Response.Status.NO_CONTENT.getStatusCode());
    }

    private static void validateResponse(int responseCode, int ... validResponses) {
        if (responseCode == Response.Status.FORBIDDEN.getStatusCode()) {
            throw SECURITY_EXCEPTION;
        }
        boolean found = false;
        for (int i = 0; i < validResponses.length; ++i) {
            if (validResponses[i] != responseCode) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("Unexpected HTTP Response code " + responseCode + " was returned from the server.");
        }
    }
}

