/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.oracle.cloud.cache.basic.Cache;
import com.oracle.cloud.cache.basic.RestCache;
import com.oracle.cloud.cache.basic.Session;
import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.SessionOption;
import com.oracle.cloud.cache.rest.JacksonMapperProvider;
import com.oracle.cloud.cache.rest.MultiValue;
import com.oracle.cloud.cache.util.Options;
import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.jackson.JacksonFeature;

public class RestSession
implements Session {
    private final Options<SessionOption> options;
    private WebTarget target;

    public RestSession(URI uri, SessionOption ... options) {
        Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MultiValue.Reader.class)).register(MultiValue.Writer.class)).register(JacksonMapperProvider.class)).register(JacksonFeature.class)).build();
        this.options = Options.from(SessionOption.class, options);
        this.target = client.target(uri);
    }

    @Override
    public <V> Cache<V> getCache(String cacheName, CacheOption ... options) {
        return new RestCache(cacheName, this, options);
    }

    public Options<SessionOption> getOptions() {
        return this.options;
    }

    public WebTarget getTarget() {
        return this.target;
    }

    public void setTarget(WebTarget target) {
        this.target = target;
    }

    public String toString() {
        return "RestSession{options=" + Arrays.toString(this.options.asArray()) + ", target=" + this.target + '}';
    }
}

