/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic.options;

import com.oracle.cloud.cache.basic.options.CacheOption;
import com.oracle.cloud.cache.basic.options.GetOption;
import com.oracle.cloud.cache.basic.options.PutOption;
import com.oracle.cloud.cache.basic.options.ReplaceOption;
import com.oracle.cloud.cache.util.Options;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Expiry
implements CacheOption,
PutOption,
ReplaceOption,
GetOption {
    private final long expiry;

    private Expiry(long expiry) {
        this.expiry = expiry;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public static Expiry of(long ttl, TimeUnit unit) {
        return new Expiry(unit.toMillis(ttl));
    }

    public static Expiry of(Duration duration) {
        return new Expiry(duration.toMillis());
    }

    public static Expiry never() {
        return new Expiry(-1L);
    }

    @Options.Default
    public static Expiry defaultExpiry() {
        return new Expiry(0L);
    }
}

