/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.oracle.cloud.cache.metrics.TimerSnapshot;

public class CacheMetrics {
    private final String cacheName;
    private final TimerSnapshot getMetrics;
    private final TimerSnapshot putMetrics;
    private final TimerSnapshot removeMetrics;
    private final TimerSnapshot loadMetrics;
    private final long hitCount;
    private final long missCount;
    private final long count;
    private final long size;

    public CacheMetrics(String cacheName, MetricRegistry metrics) {
        this.cacheName = cacheName;
        this.getMetrics = new TimerSnapshot(metrics.timer("get"));
        this.putMetrics = new TimerSnapshot(metrics.timer("put"));
        this.removeMetrics = new TimerSnapshot(metrics.timer("remove"));
        this.loadMetrics = new TimerSnapshot(metrics.timer("load"));
        this.hitCount = metrics.counter("hit").getCount();
        this.missCount = metrics.counter("miss").getCount();
        this.count = (Long)((Gauge)metrics.getGauges().get("count")).getValue();
        this.size = (Long)((Gauge)metrics.getGauges().get("size")).getValue();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public TimerSnapshot getGetMetrics() {
        return this.getMetrics;
    }

    public TimerSnapshot getPutMetrics() {
        return this.putMetrics;
    }

    public TimerSnapshot getRemoveMetrics() {
        return this.removeMetrics;
    }

    public TimerSnapshot getLoadMetrics() {
        return this.loadMetrics;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public double getHitRatio() {
        long cGets = this.hitCount + this.missCount;
        return cGets == 0L ? 0.0 : 1.0 * (double)this.hitCount / (double)cGets;
    }

    public double getMissRatio() {
        long cGets = this.hitCount + this.missCount;
        return cGets == 0L ? 0.0 : 1.0 * (double)this.missCount / (double)cGets;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "CacheMetrics{\n\tcache:  " + this.cacheName + "\n\tget:    " + this.getMetrics + "\n\tput:    " + this.putMetrics + "\n\tremove: " + this.removeMetrics + "\n\tload:   " + this.loadMetrics + "\n\thits:   [count = " + this.hitCount + ", ratio = " + this.getHitRatio() + "]" + "\n\tmisses: [count = " + this.missCount + ", ratio = " + this.getMissRatio() + "]" + "\n\tcount:  " + this.count + "\n\tsize:   " + this.size + "\n}";
    }
}

