/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.metrics;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;

public class TimerSnapshot {
    private final long count;
    private final double meanRate;
    private final double oneMinuteRate;
    private final double fiveMinuteRate;
    private final double fifteenMinuteRate;
    private final Snapshot snapshot;

    TimerSnapshot(Timer timer) {
        this.count = timer.getCount();
        this.meanRate = timer.getMeanRate();
        this.oneMinuteRate = timer.getOneMinuteRate();
        this.fiveMinuteRate = timer.getFiveMinuteRate();
        this.fifteenMinuteRate = timer.getFifteenMinuteRate();
        this.snapshot = timer.getSnapshot();
    }

    public long getCount() {
        return this.count;
    }

    public double getMeanRate() {
        return this.meanRate;
    }

    public double getOneMinuteRate() {
        return this.oneMinuteRate;
    }

    public double getFiveMinuteRate() {
        return this.fiveMinuteRate;
    }

    public double getFifteenMinuteRate() {
        return this.fifteenMinuteRate;
    }

    public double getPercentile(double quantile) {
        return this.snapshot.getValue(quantile);
    }

    public double get50thPercentile() {
        return this.snapshot.getMedian();
    }

    public double get75thPercentile() {
        return this.snapshot.get75thPercentile();
    }

    public double get95thPercentile() {
        return this.snapshot.get95thPercentile();
    }

    public double get98thPercentile() {
        return this.snapshot.get98thPercentile();
    }

    public double get99thPercentile() {
        return this.snapshot.get99thPercentile();
    }

    public double get999thPercentile() {
        return this.snapshot.get999thPercentile();
    }

    public long getMax() {
        return this.snapshot.getMax();
    }

    public double getAverage() {
        return this.snapshot.getMean();
    }

    public long getMin() {
        return this.snapshot.getMin();
    }

    public double getStdDev() {
        return this.snapshot.getStdDev();
    }

    public String toString() {
        return "[count = " + this.count + ", mean rate = " + this.meanRate + ", 1-min rate = " + this.oneMinuteRate + ", 5-min rate = " + this.fiveMinuteRate + ", 15-min rate = " + this.fifteenMinuteRate + ", 50% = " + this.get50thPercentile() + ", 75% = " + this.get75thPercentile() + ", 95% = " + this.get95thPercentile() + ", 98% = " + this.get98thPercentile() + ", 99% = " + this.get99thPercentile() + ", 99.9% = " + this.get999thPercentile() + ", max = " + this.getMax() + ", avg = " + this.getAverage() + ", min = " + this.getMin() + ", stddev = " + this.getStdDev() + ']';
    }
}

