/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.record.impl.OBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrientBlob
implements Blob {
    private final List<byte[]> binaryDataChunks;
    private long length;
    private byte[] currentChunk;
    private int currentChunkIndex;

    protected OrientBlob(OBlob binaryDataChunk) throws IllegalArgumentException {
        this(Collections.singletonList(binaryDataChunk));
    }

    protected OrientBlob(List<OBlob> binaryDataChunks) throws IllegalArgumentException {
        this.binaryDataChunks = new ArrayList<byte[]>(binaryDataChunks.size());
        for (OBlob binaryDataChunk : binaryDataChunks) {
            if (binaryDataChunk == null) {
                throw new IllegalArgumentException("The binary data chunks list cannot hold null chunks");
            }
            if (binaryDataChunk.getSize() == 0) {
                throw new IllegalArgumentException("The binary data chunks list cannot hold empty chunks");
            }
            this.binaryDataChunks.add(binaryDataChunk.toStream());
        }
        this.length = this.calculateLength();
    }

    @Override
    public long length() throws SQLException {
        return this.length;
    }

    private long calculateLength() {
        long length = 0L;
        for (byte[] binaryDataChunk : this.binaryDataChunks) {
            length += (long)binaryDataChunk.length;
        }
        return length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("The position of the first byte in the BLOB value to be extracted cannot be less than 1");
        }
        if (length < 0) {
            throw new SQLException("The number of the consecutive bytes in the BLOB value to be extracted cannot be a negative number");
        }
        int relativeIndex = this.getRelativeIndex(pos);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        for (int j = 0; j < length; ++j) {
            if (relativeIndex == this.currentChunk.length) {
                ++this.currentChunkIndex;
                if (this.currentChunkIndex >= this.binaryDataChunks.size()) break;
                relativeIndex = 0;
                this.currentChunk = this.binaryDataChunks.get(this.currentChunkIndex);
            }
            buffer.put(this.currentChunk[relativeIndex]);
            ++relativeIndex;
        }
        return buffer.array();
    }

    private int getRelativeIndex(long pos) {
        int currentSize = 0;
        this.currentChunkIndex = 0;
        while (pos >= (long)(currentSize += this.binaryDataChunks.get(this.currentChunkIndex).length)) {
            ++this.currentChunkIndex;
        }
        this.currentChunk = this.binaryDataChunks.get(this.currentChunkIndex);
        int relativePosition = (int)(pos - (long)(currentSize -= this.currentChunk.length));
        return relativePosition - 1;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new OrientBlobInputStream();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw new SQLException("The length of a BLOB cannot be a negtive number.");
        }
        if (len < this.length) {
            this.length = len;
        }
    }

    @Override
    public void free() throws SQLException {
        this.binaryDataChunks.clear();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new OrientBlobInputStream(pos, length);
    }

    static /* synthetic */ byte[] access$202(OrientBlob x0, byte[] x1) {
        x0.currentChunk = x1;
        return x1;
    }

    private class OrientBlobInputStream
    extends InputStream {
        private long bytesToBeRead;
        private int positionInTheCurrentChunk;

        public OrientBlobInputStream() {
            this.bytesToBeRead = OrientBlob.this.length;
            this.positionInTheCurrentChunk = 0;
        }

        public OrientBlobInputStream(long pos, long length) {
            this.bytesToBeRead = length;
            this.positionInTheCurrentChunk = OrientBlob.this.getRelativeIndex(pos);
        }

        @Override
        public int read() throws IOException {
            if (this.bytesToBeRead > 0L) {
                if (this.positionInTheCurrentChunk == OrientBlob.this.currentChunk.length - 1) {
                    if (OrientBlob.this.currentChunkIndex == OrientBlob.this.binaryDataChunks.size() - 1) {
                        this.bytesToBeRead = 0L;
                        return -1;
                    }
                    OrientBlob.access$202(OrientBlob.this, (byte[])OrientBlob.this.binaryDataChunks.get(++OrientBlob.this.currentChunkIndex));
                    this.positionInTheCurrentChunk = 0;
                }
                --this.bytesToBeRead;
                return OrientBlob.this.currentChunk[this.positionInTheCurrentChunk++];
            }
            return -1;
        }
    }
}

