/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class OrientJdbcStatement
implements Statement {
    protected final OrientJdbcConnection connection;
    protected final ODatabaseDocument database;
    protected final List<String> batches;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final int resultSetHoldability;
    protected final Properties info;
    protected String sql;
    protected boolean closed;
    protected OResultSet oResultSet;
    protected OrientJdbcResultSet resultSet;

    public OrientJdbcStatement(OrientJdbcConnection iConnection) {
        this(iConnection, 1003, 1007, 1);
    }

    public OrientJdbcStatement(OrientJdbcConnection iConnection, int resultSetType, int resultSetConcurrency) {
        this(iConnection, resultSetType, resultSetConcurrency, resultSetType);
    }

    public OrientJdbcStatement(OrientJdbcConnection iConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = iConnection;
        this.database = iConnection.getDatabase();
        this.database.activateOnCurrentThread();
        this.batches = new ArrayList<String>();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.info = this.connection.getInfo();
    }

    @Override
    public boolean execute(String sqlCommand) throws SQLException {
        if ("".equals(sqlCommand)) {
            return false;
        }
        this.sql = this.mayCleanForSpark(sqlCommand);
        if (this.sql.equalsIgnoreCase("select 1")) {
            OResultInternal element = new OResultInternal();
            element.setProperty("1", (Object)1);
            OInternalResultSet rs = new OInternalResultSet();
            rs.add((OResult)element);
            this.oResultSet = rs;
        } else {
            try {
                this.oResultSet = this.executeCommand(this.sql);
            }
            catch (OQueryParsingException e) {
                throw new SQLSyntaxErrorException("Error while parsing query", e);
            }
            catch (OException e) {
                throw new SQLException("Error while executing query", e);
            }
        }
        this.resultSet = new OrientJdbcResultSet(this, this.oResultSet, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        return true;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.oResultSet = this.executeCommand(sql);
            Optional res = this.oResultSet.stream().findFirst();
            if (res.isPresent()) {
                if (((OResult)res.get()).getProperty("count") != null) {
                    int n = Math.toIntExact((Long)((OResult)res.get()).getProperty("count"));
                    return n;
                }
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.oResultSet.close();
        }
    }

    protected OResultSet executeCommand(String query) throws SQLException {
        try {
            return this.database.command(query, new Object[0]);
        }
        catch (OQueryParsingException e) {
            throw new SQLSyntaxErrorException("Error while parsing command", e);
        }
        catch (OException e) {
            throw new SQLException("Error while executing command", e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batches.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results = new int[this.batches.size()];
        int i = 0;
        for (String sql : this.batches) {
            results[i++] = this.executeUpdate(sql);
        }
        return results;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSet.getType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement already closed");
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            if (this.sql == null) {
                return OCommandSQL.class.isAssignableFrom(iface);
            }
            return this.sql.getClass().isAssignableFrom(iface);
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.sql);
        }
        catch (ClassCastException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    protected String mayCleanForSpark(String sql) {
        if (Boolean.parseBoolean(this.info.getProperty("spark", "false"))) {
            if (sql.endsWith("WHERE 1=0")) {
                sql = sql.replace("WHERE 1=0", " LIMIT 1");
            }
            return sql.replace('\"', ' ');
        }
        return sql;
    }
}

