/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneFullTextIndexEngine;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class OLuceneIndexFactory
implements OIndexFactory,
ODatabaseLifecycleListener {
    public static final String LUCENE_ALGORITHM = "LUCENE";
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;

    public OLuceneIndexFactory() {
        this(false);
    }

    public OLuceneIndexFactory(boolean manual) {
        if (!manual) {
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
    }

    public int getLastVersion() {
        return 0;
    }

    public Set<String> getTypes() {
        return TYPES;
    }

    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    public OIndexInternal<?> createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        OAbstractPaginatedStorage pagStorage = (OAbstractPaginatedStorage)storage.getUnderlying();
        if (metadata == null) {
            metadata = new ODocument().field("analyzer", (Object)StandardAnalyzer.class.getName());
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equalsIgnoreCase(indexType)) {
            OLuceneFullTextIndex index = new OLuceneFullTextIndex(name, indexType, algorithm, version, pagStorage, valueContainerAlgorithm, metadata);
            return index;
        }
        throw new OConfigurationException("Unsupported type : " + algorithm);
    }

    public OIndexEngine createIndexEngine(String algorithm, String indexName, Boolean durableInNonTxMode, OStorage storage, int version, Map<String, String> engineProperties) {
        return new OLuceneFullTextIndexEngine(storage, indexName);
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.REGULAR;
    }

    public void onCreate(ODatabaseInternal db) {
        OLogManager.instance().debug((Object)this, "onCreate", new Object[0]);
    }

    public void onOpen(ODatabaseInternal db) {
        OLogManager.instance().debug((Object)this, "onOpen", new Object[0]);
    }

    public void onClose(ODatabaseInternal db) {
        OLogManager.instance().debug((Object)this, "onClose", new Object[0]);
    }

    public void onDrop(ODatabaseInternal db) {
        try {
            if (db.isClosed()) {
                return;
            }
            OLogManager.instance().debug((Object)this, "Dropping Lucene indexes...", new Object[0]);
            db.getMetadata().getIndexManager().getIndexes().stream().filter(idx -> idx.getInternal() instanceof OLuceneFullTextIndex).peek(idx -> OLogManager.instance().debug((Object)this, "deleting index " + idx.getName(), new Object[0])).forEach(idx -> idx.delete());
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on dropping Lucene indexes", (Throwable)e, new Object[0]);
        }
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(LUCENE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

