/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class OLuceneDateTools {
    private static final Resolution[] RESOLUTIONS = new Resolution[Resolution.MILLISECOND.formatLen + 1];

    private OLuceneDateTools() {
    }

    public static long stringToTime(String dateString) throws ParseException {
        return OLuceneDateTools.stringToDate(dateString).getTime();
    }

    public static Date stringToDate(String dateString) throws ParseException {
        try {
            SimpleDateFormat format = RESOLUTIONS[dateString.length()].format();
            return format.parse(dateString);
        }
        catch (Exception e) {
            throw new ParseException("Input is not a valid date string: " + dateString, 0);
        }
    }

    static {
        Resolution[] resolutionArray = Resolution.values();
        int n = resolutionArray.length;
        for (int i = 0; i < n; ++i) {
            Resolution resolution;
            OLuceneDateTools.RESOLUTIONS[resolution.formatLen] = resolution = resolutionArray[i];
        }
    }

    public static enum Resolution {
        YEAR(4),
        MONTH(6),
        DAY(8),
        HOUR(10),
        MINUTE(12),
        SECOND(14),
        MILLISECOND(17);

        final int formatLen;

        private Resolution(int formatLen) {
            this.formatLen = formatLen;
        }

        public SimpleDateFormat format() {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS".substring(0, this.formatLen), Locale.ROOT);
            format.setTimeZone(ODateHelper.getDatabaseTimeZone());
            return format;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

