/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.lucene.analyzer.OLuceneAnalyzerFactory;
import com.orientechnologies.lucene.parser.OLuceneMultiFieldQueryParser;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public class OLuceneQueryBuilder {
    public static final ODocument EMPTY_METADATA = new ODocument();
    private final boolean allowLeadingWildcard;
    private final boolean lowercaseExpandedTerms;
    private final OLuceneAnalyzerFactory analyzerFactory;

    public OLuceneQueryBuilder(ODocument metadata) {
        this((Boolean)Optional.ofNullable(metadata.field("allowLeadingWildcard")).orElse(false), (Boolean)Optional.ofNullable(metadata.field("lowercaseExpandedTerms")).orElse(true));
    }

    public OLuceneQueryBuilder(boolean allowLeadingWildcard, boolean lowercaseExpandedTerms) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        this.analyzerFactory = new OLuceneAnalyzerFactory();
    }

    public Query query(OIndexDefinition index, Object key, ODocument metadata, Analyzer analyzer) throws com.orientechnologies.orient.core.sql.parser.ParseException {
        String query;
        if (key instanceof OCompositeKey) {
            Object params = ((OCompositeKey)key).getKeys().get(0);
            query = params.toString();
        } else {
            query = key.toString();
        }
        if (query.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return this.buildQuery(index, query, metadata, analyzer);
    }

    protected Query buildQuery(OIndexDefinition index, String query, ODocument metadata, Analyzer queryAnalyzer) throws com.orientechnologies.orient.core.sql.parser.ParseException {
        int i;
        String[] fields;
        if (index.isAutomatic()) {
            fields = index.getFields().toArray(new String[index.getFields().size()]);
        } else {
            int length = index.getTypes().length;
            fields = new String[length];
            for (i = 0; i < length; ++i) {
                fields[i] = "k" + i;
            }
        }
        HashMap<String, OType> types = new HashMap<String, OType>();
        for (i = 0; i < fields.length; ++i) {
            String field = fields[i];
            types.put(field, index.getTypes()[i]);
        }
        return this.getQuery(index, query, metadata, queryAnalyzer, fields, types);
    }

    private Query getQuery(OIndexDefinition index, String query, ODocument metadata, Analyzer queryAnalyzer, String[] fields, Map<String, OType> types) throws com.orientechnologies.orient.core.sql.parser.ParseException {
        Map boost = Optional.ofNullable(metadata.getProperty("boost")).orElse(new HashMap());
        Analyzer analyzer = Optional.ofNullable(metadata.getProperty("customAnalysis")).filter(b -> b == true).map(b -> this.analyzerFactory.createAnalyzer(index, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, metadata)).orElse(queryAnalyzer);
        OLuceneMultiFieldQueryParser queryParser = new OLuceneMultiFieldQueryParser(types, fields, analyzer, boost);
        queryParser.setAllowLeadingWildcard((Boolean)Optional.ofNullable(metadata.getProperty("allowLeadingWildcard")).orElse(this.allowLeadingWildcard));
        queryParser.setLowercaseExpandedTerms((Boolean)Optional.ofNullable(metadata.getProperty("lowercaseExpandedTerms")).orElse(this.lowercaseExpandedTerms));
        try {
            return queryParser.parse(query);
        }
        catch (ParseException e) {
            throw new com.orientechnologies.orient.core.sql.parser.ParseException(e.getMessage());
        }
    }
}

