/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.builder.OLuceneDocumentBuilder;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.collections.OLuceneIndexCursor;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.store.Directory;

public class OLuceneFullTextIndexEngine
extends OLuceneIndexEngineAbstract {
    private OLuceneDocumentBuilder builder = new OLuceneDocumentBuilder();
    private OLuceneQueryBuilder queryBuilder;

    public OLuceneFullTextIndexEngine(OStorage storage, String idxName) {
        super(storage, idxName);
    }

    @Override
    public IndexWriter openIndexWriter(Directory directory) throws IOException {
        return this.createIndexWriter(directory);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        super.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
        this.queryBuilder = new OLuceneQueryBuilder(metadata);
    }

    @Override
    public IndexWriter createIndexWriter(Directory directory) throws IOException {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return fc.createIndexWriter(directory, this.metadata, this.indexAnalyzer());
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void onRecordAddedToResultSet(final OLuceneQueryContext queryContext, OContextualRecordId recordId, Document ret, final ScoreDoc score) {
        recordId.setContext((Map)new HashMap<String, Object>(){
            {
                HashMap<String, TextFragment[]> frag = queryContext.getFragments();
                frag.entrySet().stream().forEach((? super T f) -> {
                    TextFragment[] fragments = (TextFragment[])f.getValue();
                    StringBuilder hlField = new StringBuilder();
                    for (int j = 0; j < fragments.length; ++j) {
                        if (fragments[j] == null || !(fragments[j].getScore() > 0.0f)) continue;
                        hlField.append(fragments[j].toString());
                    }
                    this.put("$" + (String)f.getKey() + "_hl", hlField.toString());
                });
                this.put("$score", Float.valueOf(score.score));
            }
        });
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            Query query = new QueryParser("", this.queryAnalyzer()).parse((String)key);
            this.deleteDocument(query);
            return true;
        }
        catch (org.apache.lucene.queryparser.classic.ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object get(Object key) {
        return this.getInTx(key, null);
    }

    public void put(Object key, Object value) {
        this.updateLastAccess();
        this.openIfClosed();
        Collection container = (Collection)value;
        for (OIdentifiable oIdentifiable : container) {
            Document doc = this.buildDocument(key, oIdentifiable);
            this.addDocument(doc);
        }
    }

    public boolean validatedPut(Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) {
        throw new UnsupportedOperationException("Validated put is not supported by OLuceneFullTextIndexEngine");
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OLuceneIndexCursor((OLuceneResultSet)this.get(rangeFrom), rangeFrom);
    }

    private Set<OIdentifiable> getResults(Query query, OCommandContext context, OLuceneTxChanges changes, ODocument metadata) {
        IndexSearcher searcher = this.searcher();
        OLuceneQueryContext queryContext = new OLuceneQueryContext(context, searcher, query).withChanges(changes);
        return new OLuceneResultSet(this, queryContext, metadata);
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        if (this.indexDefinition.isAutomatic()) {
            return this.builder.build(this.indexDefinition, key, value, this.collectionFields, this.metadata);
        }
        return this.putInManualindex(key, value);
    }

    private Document putInManualindex(Object key, OIdentifiable oIdentifiable) {
        Document doc = new Document();
        doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES));
        if (key instanceof OCompositeKey) {
            List keys = ((OCompositeKey)key).getKeys();
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.YES));
                ++k;
            }
        } else if (key instanceof Collection) {
            Collection keys = (Collection)key;
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.YES));
                ++k;
            }
        } else {
            doc.add((IndexableField)OLuceneIndexType.createField("k0", key, Field.Store.NO));
        }
        return doc;
    }

    @Override
    public Query buildQuery(Object maybeQuery) {
        try {
            if (maybeQuery instanceof String) {
                return this.queryBuilder.query(this.indexDefinition, maybeQuery, OLuceneQueryBuilder.EMPTY_METADATA, this.queryAnalyzer());
            }
            OLuceneKeyAndMetadata q = (OLuceneKeyAndMetadata)maybeQuery;
            Query query = this.queryBuilder.query(this.indexDefinition, (Object)q.key, q.metadata, this.queryAnalyzer());
            return query;
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing query"), (Throwable)e);
        }
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            if (key instanceof OLuceneKeyAndMetadata) {
                OLuceneKeyAndMetadata q = (OLuceneKeyAndMetadata)key;
                Query query = this.queryBuilder.query(this.indexDefinition, (Object)q.key, q.metadata, this.queryAnalyzer());
                OCommandContext commandContext = q.key.getContext();
                return this.getResults(query, commandContext, changes, q.metadata);
            }
            Query query = this.queryBuilder.query(this.indexDefinition, key, OLuceneQueryBuilder.EMPTY_METADATA, this.queryAnalyzer());
            OCommandContext commandContext = null;
            if (key instanceof OLuceneCompositeKey) {
                commandContext = ((OLuceneCompositeKey)((Object)key)).getContext();
            }
            return this.getResults(query, commandContext, changes, OLuceneQueryBuilder.EMPTY_METADATA);
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing lucene query"), (Throwable)e);
        }
    }
}

