/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.query;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.highlight.TextFragment;

public class OLuceneQueryContext {
    private final OCommandContext context;
    private final IndexSearcher searcher;
    private final Query query;
    private final Sort sort;
    private final QueryContextCFG cfg;
    private Optional<OLuceneTxChanges> changes;
    private HashMap<String, TextFragment[]> fragments;

    public OLuceneQueryContext(OCommandContext context, IndexSearcher searcher, Query query) {
        this(context, searcher, query, null);
    }

    public OLuceneQueryContext(OCommandContext context, IndexSearcher searcher, Query query, Sort sort) {
        this.context = context;
        this.searcher = searcher;
        this.query = query;
        this.sort = sort;
        this.cfg = sort != null ? QueryContextCFG.SORT : QueryContextCFG.FILTER;
        this.changes = Optional.empty();
        this.fragments = new HashMap();
    }

    public boolean isInTx() {
        return this.changes.isPresent();
    }

    public OLuceneQueryContext withChanges(OLuceneTxChanges changes) {
        this.changes = Optional.ofNullable(changes);
        return this;
    }

    public OLuceneQueryContext addHighlightFragment(String field, TextFragment[] fieldFragment) {
        this.fragments.put(field, fieldFragment);
        return this;
    }

    public OCommandContext getContext() {
        return this.context;
    }

    public Query getQuery() {
        return this.query;
    }

    public Sort getSort() {
        return this.sort;
    }

    public IndexSearcher getSearcher() {
        return this.changes.map(c -> new IndexSearcher((IndexReader)this.multiReader((OLuceneTxChanges)c))).orElse(this.searcher);
    }

    private MultiReader multiReader(OLuceneTxChanges c) {
        try {
            return new MultiReader(new IndexReader[]{this.searcher.getIndexReader(), c.searcher().getIndexReader()});
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("unable to create reader on changes"), (Throwable)e);
        }
    }

    public QueryContextCFG getCfg() {
        return this.cfg;
    }

    public int deletedDocs(Query query) {
        return this.changes.map(c -> c.deletedDocs(query)).orElse(0);
    }

    public boolean isUpdated(Document doc, Object key, OIdentifiable value) {
        return this.changes.map(c -> c.isUpdated(doc, key, value)).orElse(false);
    }

    public boolean isDeleted(Document doc, Object key, OIdentifiable value) {
        return this.changes.map(c -> c.isDeleted(doc, key, value)).orElse(false);
    }

    public HashMap<String, TextFragment[]> getFragments() {
        return this.fragments;
    }

    public static enum QueryContextCFG {
        FILTER,
        SORT;

    }
}

