/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;

public final class SeverityLevelCounter
implements AuditListener {
    private SeverityLevel mLevel;
    private int mCount;

    public SeverityLevelCounter(SeverityLevel aLevel) {
        if (aLevel == null) {
            throw new IllegalArgumentException();
        }
        this.mLevel = aLevel;
    }

    @Override
    public void addError(AuditEvent aEvt) {
        if (this.mLevel.equals((Object)aEvt.getSeverityLevel())) {
            ++this.mCount;
        }
    }

    @Override
    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        if (SeverityLevel.ERROR.equals((Object)this.mLevel)) {
            ++this.mCount;
        }
    }

    @Override
    public void auditStarted(AuditEvent aEvt) {
        this.mCount = 0;
    }

    @Override
    public void fileStarted(AuditEvent aEvt) {
    }

    @Override
    public void auditFinished(AuditEvent aEvt) {
    }

    @Override
    public void fileFinished(AuditEvent aEvt) {
    }

    public int getCount() {
        return this.mCount;
    }
}

