/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import antlr.collections.AST;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class VisibilityModifierCheck
extends Check {
    private boolean mProtectedAllowed;
    private boolean mPackageAllowed;
    private String mPublicMemberFormat = "^serialVersionUID$";
    private Pattern mPublicMemberPattern;

    public VisibilityModifierCheck() {
        this.setPublicMemberPattern(this.mPublicMemberFormat);
    }

    public boolean isProtectedAllowed() {
        return this.mProtectedAllowed;
    }

    public void setProtectedAllowed(boolean aProtectedAllowed) {
        this.mProtectedAllowed = aProtectedAllowed;
    }

    public boolean isPackageAllowed() {
        return this.mPackageAllowed;
    }

    public void setPackageAllowed(boolean aPackageAllowed) {
        this.mPackageAllowed = aPackageAllowed;
    }

    public void setPublicMemberPattern(String aPattern) {
        try {
            this.mPublicMemberPattern = Utils.getPattern(aPattern);
            this.mPublicMemberFormat = aPattern;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aPattern, (Throwable)e);
        }
    }

    private Pattern getPublicMemberRegexp() {
        return this.mPublicMemberPattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String variableScope;
        if (aAST.getType() != 10 || aAST.getParent().getType() != 6) {
            return;
        }
        DetailAST varNameAST = this.getVarNameAST(aAST);
        String varName = varNameAST.getText();
        boolean inInterfaceOrAnnotationBlock = ScopeUtils.inInterfaceOrAnnotationBlock(aAST);
        Set<String> mods = this.getModifiers(aAST);
        String declaredScope = this.getVisibilityScope(mods);
        String string = variableScope = inInterfaceOrAnnotationBlock ? "public" : declaredScope;
        if (!("private".equals(variableScope) || inInterfaceOrAnnotationBlock || mods.contains("static") && mods.contains("final") || "package".equals(variableScope) && this.isPackageAllowed() || "protected".equals(variableScope) && this.isProtectedAllowed() || "public".equals(variableScope) && this.getPublicMemberRegexp().matcher(varName).find())) {
            this.log(varNameAST.getLineNo(), varNameAST.getColumnNo(), "variable.notPrivate", varName);
        }
    }

    private DetailAST getVarNameAST(DetailAST aVariableDefAST) {
        DetailAST ast = aVariableDefAST.getFirstChild();
        while (ast != null) {
            DetailAST nextSibling = ast.getNextSibling();
            if (ast.getType() == 13) {
                return nextSibling;
            }
            ast = nextSibling;
        }
        return null;
    }

    private Set<String> getModifiers(DetailAST aVariableDefAST) {
        DetailAST modifiersAST = aVariableDefAST.getFirstChild();
        if (modifiersAST.getType() != 5) {
            throw new IllegalStateException("Strange parse tree");
        }
        HashSet retVal = Sets.newHashSet();
        for (AST modifier = modifiersAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            retVal.add(modifier.getText());
        }
        return retVal;
    }

    private String getVisibilityScope(Set<String> aModifiers) {
        String[] explicitModifiers;
        for (String candidate : explicitModifiers = new String[]{"public", "private", "protected"}) {
            if (!aModifiers.contains(candidate)) continue;
            return candidate;
        }
        return "package";
    }
}

