/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;

public class SeparatorWrapCheck
extends AbstractOptionCheck<WrapOption> {
    public SeparatorWrapCheck() {
        super(WrapOption.EOL, WrapOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{60, 75};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{60, 75, 46, 175, 174, 77, 78, 17, 49};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String text = aAST.getText();
        int colNo = aAST.getColumnNo();
        int lineNo = aAST.getLineNo();
        String currentLine = this.getLines()[lineNo - 1];
        String substringAfterToken = currentLine.substring(colNo + text.length()).trim();
        String substringBeforeToken = currentLine.substring(0, colNo).trim();
        WrapOption wSp = (WrapOption)((Object)this.getAbstractOption());
        if (wSp == WrapOption.EOL && substringBeforeToken.length() == 0) {
            this.log(lineNo, colNo, "line.previous", text);
        } else if (wSp == WrapOption.NL && substringAfterToken.length() == 0) {
            this.log(lineNo, colNo, "line.new", text);
        }
    }
}

