/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.instancemode;

import io.grpc.BindableService;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.util.Collection;
import java.util.function.Supplier;

public class PerCallService<T extends BindableService>
implements BindableService {
    private ServerServiceDefinition perCallBinding;

    public PerCallService(Supplier<T> factory) {
        this.perCallBinding = this.bindService(factory);
    }

    public PerCallService(Class<T> clazz) {
        this(() -> {
            try {
                return (BindableService)clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Class " + clazz.getName() + " must have a public default constructor", e);
            }
        });
    }

    private ServerServiceDefinition bindService(Supplier<T> factory) {
        ServerServiceDefinition baseDefinition = ((BindableService)factory.get()).bindService();
        ServiceDescriptor descriptor = baseDefinition.getServiceDescriptor();
        Collection<ServerMethodDefinition<?, ?>> methods = baseDefinition.getMethods();
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder(descriptor);
        methods.forEach(method -> builder.addMethod(ServerMethodDefinition.create(method.getMethodDescriptor(), new PerCallServerCallHandler(factory))));
        return builder.build();
    }

    @Override
    public ServerServiceDefinition bindService() {
        return this.perCallBinding;
    }

    private class PerCallServerCallHandler
    implements ServerCallHandler {
        private Supplier<T> factory;

        PerCallServerCallHandler(Supplier<T> factory) {
            this.factory = factory;
        }

        public ServerCall.Listener startCall(ServerCall call, Metadata headers) {
            final BindableService instance = (BindableService)this.factory.get();
            ServerServiceDefinition definition = instance.bindService();
            ServerMethodDefinition<?, ?> method = definition.getMethod(call.getMethodDescriptor().getFullMethodName());
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<T>(method.getServerCallHandler().startCall(call, headers)){

                @Override
                public void onCancel() {
                    super.onCancel();
                    this.close();
                }

                @Override
                public void onComplete() {
                    super.onComplete();
                    this.close();
                }

                private void close() {
                    if (instance instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)instance)).close();
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                }
            };
        }
    }
}

