/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.google.common.base.Stopwatch;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopwatchClientInterceptor
implements ClientInterceptor {
    private final Logger logger = LoggerFactory.getLogger(StopwatchClientInterceptor.class);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        this.logStart(method);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            private Stopwatch stopwatch;
            {
                super(x0);
                this.stopwatch = Stopwatch.createStarted();
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        super.onClose(status, trailers);
                        StopwatchClientInterceptor.this.logStop(method, Duration.ofNanos(stopwatch.stop().elapsed(TimeUnit.NANOSECONDS)));
                    }
                }, headers);
            }
        };
    }

    protected void logStart(MethodDescriptor method) {
        this.logger.info("Begin call op:" + method.getFullMethodName());
    }

    protected void logStop(MethodDescriptor method, Duration duration) {
        this.logger.info("End call op:" + method.getFullMethodName() + " duration:" + duration);
    }
}

