/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.NetworkSettings;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerInfo {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Created")
    private Date created;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="Args")
    private ImmutableList<String> args;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="ProcessLabel")
    private String processLabel;
    @JsonProperty(value="MountLabel")
    private String mountLabel;
    @JsonProperty(value="Volumes")
    private ImmutableMap<String, String> volumes;
    @JsonProperty(value="VolumesRW")
    private ImmutableMap<String, Boolean> volumesRW;

    public String id() {
        return this.id;
    }

    public Date created() {
        return this.created == null ? null : new Date(this.created.getTime());
    }

    public String path() {
        return this.path;
    }

    public List<String> args() {
        return this.args;
    }

    public ContainerConfig config() {
        return this.config;
    }

    public HostConfig hostConfig() {
        return this.hostConfig;
    }

    public ContainerState state() {
        return this.state;
    }

    public String image() {
        return this.image;
    }

    public NetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public String resolvConfPath() {
        return this.resolvConfPath;
    }

    public String hostnamePath() {
        return this.hostnamePath;
    }

    public String hostsPath() {
        return this.hostsPath;
    }

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public String execDriver() {
        return this.execDriver;
    }

    public String processLabel() {
        return this.processLabel;
    }

    public String mountLabel() {
        return this.mountLabel;
    }

    public Map<String, String> volumes() {
        return this.volumes;
    }

    public Map<String, Boolean> volumesRW() {
        return this.volumesRW;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.execDriver != null ? !this.execDriver.equals(that.execDriver) : that.execDriver != null) {
            return false;
        }
        if (this.hostnamePath != null ? !this.hostnamePath.equals(that.hostnamePath) : that.hostnamePath != null) {
            return false;
        }
        if (this.hostsPath != null ? !this.hostsPath.equals(that.hostsPath) : that.hostsPath != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.mountLabel != null ? !this.mountLabel.equals(that.mountLabel) : that.mountLabel != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.networkSettings != null ? !this.networkSettings.equals(that.networkSettings) : that.networkSettings != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.processLabel != null ? !this.processLabel.equals(that.processLabel) : that.processLabel != null) {
            return false;
        }
        if (this.resolvConfPath != null ? !this.resolvConfPath.equals(that.resolvConfPath) : that.resolvConfPath != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.volumesRW != null ? !this.volumesRW.equals(that.volumesRW) : that.volumesRW != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.hostConfig != null ? this.hostConfig.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.networkSettings != null ? this.networkSettings.hashCode() : 0);
        result = 31 * result + (this.resolvConfPath != null ? this.resolvConfPath.hashCode() : 0);
        result = 31 * result + (this.hostnamePath != null ? this.hostnamePath.hashCode() : 0);
        result = 31 * result + (this.hostsPath != null ? this.hostsPath.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
        result = 31 * result + (this.execDriver != null ? this.execDriver.hashCode() : 0);
        result = 31 * result + (this.processLabel != null ? this.processLabel.hashCode() : 0);
        result = 31 * result + (this.mountLabel != null ? this.mountLabel.hashCode() : 0);
        result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
        result = 31 * result + (this.volumesRW != null ? this.volumesRW.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("created", (Object)this.created).add("path", (Object)this.path).add("args", this.args).add("config", (Object)this.config).add("hostConfig", (Object)this.hostConfig).add("state", (Object)this.state).add("image", (Object)this.image).add("networkSettings", (Object)this.networkSettings).add("resolvConfPath", (Object)this.resolvConfPath).add("hostnamePath", (Object)this.hostnamePath).add("hostsPath", (Object)this.hostsPath).add("name", (Object)this.name).add("driver", (Object)this.driver).add("execDriver", (Object)this.execDriver).add("processLabel", (Object)this.processLabel).add("mountLabel", (Object)this.mountLabel).add("volumes", this.volumes).add("volumesRW", this.volumesRW).toString();
    }
}

