/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.SimpleType;
import java.io.Serializable;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    public static final BasicClassIntrospector instance;

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findCachedDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), bl ? mapperConfig.getAnnotationIntrospector() : null, mixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        boolean bl = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(javaType.getRawClass(), bl ? annotationIntrospector : null, mixInResolver);
        return BasicBeanDescription.forOtherUse(mapperConfig, javaType, annotatedClass);
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl, String string) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), bl2 ? mapperConfig.getAnnotationIntrospector() : null, mixInResolver);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string).collect();
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl) {
        boolean bl2 = mapperConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector annotationIntrospector = bl2 ? mapperConfig.getAnnotationIntrospector() : null;
        AnnotatedClass annotatedClass = AnnotatedClass.construct(javaType.getRawClass(), annotationIntrospector, mixInResolver);
        JsonPOJOBuilder.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
        String string = value == null ? "with" : value.withPrefix;
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl, string).collect();
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findCachedDesc(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz == String.class) {
            return STRING_DESC;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN_DESC;
        }
        if (clazz == Integer.TYPE) {
            return INT_DESC;
        }
        if (clazz == Long.TYPE) {
            return LONG_DESC;
        }
        return null;
    }

    static {
        AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(String.class, null, null);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Boolean.TYPE, null, null);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Integer.TYPE, null, null);
        INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), annotatedClass);
        annotatedClass = AnnotatedClass.constructWithoutSuperTypes(Long.TYPE, null, null);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), annotatedClass);
        instance = new BasicClassIntrospector();
    }
}

