//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[host](host.md)

# host

[jvm]\

@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;host&quot;)

val [host](host.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

The host address suitable for use with [InetAddress.getAllByName](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html#getAllByName-kotlin.String-). May be:

- 
   A regular host name, like android.com.
- 
   An IPv4 address, like 127.0.0.1.
- 
   An IPv6 address, like ::1. Note that there are no square braces.
- 
   An encoded IDN, like xn--n3h.net.

| URL | host() |
|---|---|
| http://android.com/ | &quot;android.com&quot; |
| http://127.0.0.1/ | &quot;127.0.0.1&quot; |
| http://[::1]/ | &quot;::1&quot; |
| http://xn--n3h.net/ | &quot;xn--n3h.net&quot; |
