//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[pingInterval](ping-interval.md)

# pingInterval

[jvm]\
fun [pingInterval](ping-interval.md)(interval: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)

@IgnoreJRERequirement

fun [pingInterval](ping-interval.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)

Sets the interval between HTTP/2 and web socket pings initiated by this client. Use this to automatically send ping frames until either the connection fails or it is closed. This keeps the connection alive and may detect connectivity failures.

If the server does not respond to each ping with a pong within interval, this client will assume that connectivity has been lost. When this happens on a web socket the connection is canceled and its listener is [notified](../../-web-socket-listener/on-failure.md). When it happens on an HTTP/2 connection the connection is closed and any calls it is carrying [will fail with an IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html).

The default value of 0 disables client-initiated pings.
