//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Dispatcher](index.md)

# Dispatcher

[jvm]\
class [Dispatcher](index.md)

Policy on when async requests are executed.

Each dispatcher uses an [ExecutorService](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html) to run calls internally. If you supply your own executor, it should be able to run [the configured maximum](max-requests.md) number of calls concurrently.

## Constructors

| | |
|---|---|
| [Dispatcher](-dispatcher.md) | [jvm]<br>fun [Dispatcher](-dispatcher.md)(executorService: [ExecutorService](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html)) |
| [Dispatcher](-dispatcher.md) | [jvm]<br>fun [Dispatcher](-dispatcher.md)() |

## Functions

| Name | Summary |
|---|---|
| [cancelAll](cancel-all.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [cancelAll](cancel-all.md)()<br>Cancel all calls currently enqueued or executing. Includes calls executed both [synchronously](../-call/execute.md) and [asynchronously](../-call/enqueue.md). |
| [queuedCalls](queued-calls.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [queuedCalls](queued-calls.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Call](../-call/index.md)&gt;<br>Returns a snapshot of the calls currently awaiting execution. |
| [queuedCallsCount](queued-calls-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [queuedCallsCount](queued-calls-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [runningCalls](running-calls.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [runningCalls](running-calls.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Call](../-call/index.md)&gt;<br>Returns a snapshot of the calls currently being executed. |
| [runningCallsCount](running-calls-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [runningCallsCount](running-calls-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

## Properties

| Name | Summary |
|---|---|
| [executorService](executor-service.md) | [jvm]<br>@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;executorService&quot;)<br>val [executorService](executor-service.md): [ExecutorService](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html) |
| [idleCallback](idle-callback.md) | [jvm]<br>@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>@set:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>var [idleCallback](idle-callback.md): [Runnable](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)? = null<br>A callback to be invoked each time the dispatcher becomes idle (when the number of running calls returns to zero). |
| [maxRequests](max-requests.md) | [jvm]<br>@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>var [maxRequests](max-requests.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 64<br>The maximum number of requests to execute concurrently. Above this requests queue in memory, waiting for the running calls to complete. |
| [maxRequestsPerHost](max-requests-per-host.md) | [jvm]<br>@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>var [maxRequestsPerHost](max-requests-per-host.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 5<br>The maximum number of requests for each host to execute concurrently. This limits requests by the URL's host name. Note that concurrent requests to a single IP address may still exceed this limit: multiple hostnames may share an IP address or be routed through the same HTTP proxy. |
