//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[queryParameterNames](query-parameter-names.md)

# queryParameterNames

[jvm]\

@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;queryParameterNames&quot;)

val [queryParameterNames](query-parameter-names.md): [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;

The distinct query parameter names in this URL, like `["a", "b"]` for `http://host/?a=apple&b=banana`. If this URL has no query this is the empty set.

| URL | `queryParameterNames()` |
|---|---|
| `http://host/` | `[]` |
| `http://host/?` | `[""]` |
| `http://host/?a=apple&k=key+lime` | `["a", "k"]` |
| `http://host/?a=apple&a=apricot` | `["a"]` |
| `http://host/?a=apple&b` | `["a", "b"]` |
